% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_methy.R
\name{query_methy}
\alias{query_methy}
\title{Query methylation data}
\usage{
query_methy(
  x,
  chr,
  start,
  end,
  simplify = TRUE,
  force = FALSE,
  truncate = TRUE,
  site_filter = getOption("NanoMethViz.site_filter", 3L)
)
}
\arguments{
\item{x}{the NanoMethResults object or a path to the methylation data
(tabix-bgzipped).}

\item{chr}{the vector of chromosomes}

\item{start}{the vector of start positions}

\item{end}{the vector of end positions}

\item{simplify}{whether returned results should be row-concatenated}

\item{force}{whether to force empty output when query region 'chr' does not
appear in data. Without 'force', an empty result indicates that the
requested 'chr' appears in the data but no data overlaps with requested
region, and an invalid 'chr' will cause an error.}

\item{truncate}{when querying from ModBamFiles, whether or not to truncate
returned results to only those within the specified region. Otherwise
methylation data for entire reads overlapping the region will be returned.}

\item{site_filter}{the minimum amount of coverage to report a site. This
filters the queried data such that any site with less than the filter is
not returned. The default is 1, which means that all sites are returned.
This option can be set globally using the \code{options(site_filter = ...)}
which will affect all plotting functions in NanoMethviz.}
}
\value{
A table containing the data within the queried regions. If simplify
is TRUE (default) then returns all data in a single table, otherwise returns
a list of tables where each table is the data from one region.
}
\description{
Query methylation data
}
\details{
The argument \code{site_filter} can be set globally using the \code{options(site_filter = ...)} command. The same data entry may appear multiple times in the output
if it overlaps multiple regions.
}
\examples{
nmr <- load_example_nanomethresult()
query_methy(methy(nmr), "chr7", 6703892, 6730431)

}
