% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region_methy_stats.R
\name{region_methy_stats}
\alias{region_methy_stats}
\title{Calculate region methylation statistics}
\usage{
region_methy_stats(nmr, regions, threshold = 0.5)
}
\arguments{
\item{nmr}{the NanoMethResult object.}

\item{regions}{the table of regions to query statistics for.}

\item{threshold}{the threshold to use for determining methylation calls
for the calculation of prevalence.}
}
\value{
table of regions with additional columns of methylation summary
statistics.
}
\description{
Calculate the average methylation probability and prevalence based on
specified probability threshold.
}
\examples{
nmr <- load_example_nanomethresult()
gene_anno <- exons_to_genes(NanoMethViz::exons(nmr))
region_methy_stats(nmr, gene_anno)
}
