% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nanostringPCA.R
\name{nanostringPCA}
\alias{nanostringPCA}
\title{Plot PCA}
\usage{
nanostringPCA(
  ns,
  pc1 = 1,
  pc2 = 2,
  interactive.plot = FALSE,
  exclude.zeros = TRUE,
  codeclass.retain = "endogenous"
)
}
\arguments{
\item{ns}{Processed NanoString data}

\item{pc1}{Principal component to plot on x-axis (default 1)}

\item{pc2}{Principal component to plot on y-axis (default 2)}

\item{interactive.plot}{Plot using plotly? Default FALSE (in which case
ggplot2 is used)}

\item{exclude.zeros}{Exclude genes that are not detected in all samples
(default TRUE)}

\item{codeclass.retain}{The CodeClasses to retain for principal components 
analysis.Generally we're interested in endogenous genes, so we keep 
"endogenous" only by default. Others can be included by entering a character 
vector for this option. Alternatively, all targets can be retained by 
setting this option to ".".}
}
\value{
A list containing:
\item{pca}{The PCA object}
\item{plt}{The PCA plot}
}
\description{
Conduct principal components analysis and plot the results, using either
ggplot2 or plotly.
}
\examples{
example_data <- system.file("extdata", "GSE117751_RAW", package = "NanoTube")
sample_data <- system.file("extdata", "GSE117751_sample_data.csv", 
                           package = "NanoTube")

# Process and normalize data first
dat <- processNanostringData(example_data, 
                             sampleTab = sample_data, 
                             groupCol = "Sample_Diagnosis",
                             normalization = "nSolver", 
                             bgType = "t.test", bgPVal = 0.01)
                               
# Interactive PCA using plotly                             
nanostringPCA(dat, interactive.plot = TRUE)$plt

# Static plot using ggplot2, for the 3rd and 4th PC's.
nanostringPCA(dat, pc1 = 3, pc2 = 4, interactive.plot = FALSE)$plt
}
