% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsdiffToFGSEA.R
\name{nsdiffToFGSEA}
\alias{nsdiffToFGSEA}
\title{Run gene set enrichment analysis using DE results.}
\usage{
nsdiffToFGSEA(deResults, gene.sets, sourceDB = NULL, min.set = 1)
}
\arguments{
\item{deResults}{Result from NanoStringDiff::glm.LRT.}

\item{gene.sets}{Gene set file name, in .rds (list), .gmt, or .tab format;
or a list object containing the gene sets. Gene names must be
in the same form as in the ranked.list.}

\item{sourceDB}{Source database to include, only if using a .tab-format 
geneset.file from CPDB.}

\item{min.set}{Number of genes required to conduct analysis on a given gene 
set (default = 1). If fewer than this number of genes from limmaResults are 
included in a gene set, that gene set will be skipped for this analysis.}
}
\value{
A list containing data frames with the fgsea results.
}
\description{
Use the fgsea library to run gene set enrichment analysis from the 
NanoStringDiff analysis results. Genes will be ranked by their log2 fold
changes.
}
\examples{

\donttest{
 
example_data <- system.file("extdata", "GSE117751_RAW", package = "NanoTube")
sample_data <- system.file("extdata", "GSE117751_sample_data.csv", 
                           package = "NanoTube")

datNoNorm <- processNanostringData(nsFiles = example_data,
                                   sampleTab = sample_data, 
                                   groupCol = "Sample_Diagnosis",
                                   normalization = "none")

# Convert to NanoString Set, retaining 2 samples per group for this example
# (will run faster, but still pretty slow)
nsDiffSet <- makeNanoStringSetFromEset(datNoNorm[,c(1,2,15,16,29,30)])

# Run NanoStringDiff analysis
nsDiffSet <- NanoStringDiff::estNormalizationFactors(nsDiffSet)
result <- NanoStringDiff::glm.LRT(nsDiffSet, 
                                  design.full = as.matrix(pData(nsDiffSet)),
                                  contrast = c(1, -1, 0)) 
                                  #contrast: Autoimmune retinopathy vs. None

# FGSEA with example pathways, only for pathways with at least 5 genes
# analyzed in NanoString experiment
data("ExamplePathways")
fgseaResult <- nsdiffToFGSEA(result, gene.sets = ExamplePathways,
                             min.set = 5)


}
}
