% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_rcc.R
\name{read_rcc}
\alias{read_rcc}
\title{Read .rcc file}
\usage{
read_rcc(file)
}
\arguments{
\item{file}{file name}
}
\value{
list containing expression data, sample attributes, and basic qc from
the .rcc file.
}
\description{
This function reads in a single .rcc file and splits into expression, 
sample data, and qc components.
}
\examples{
example_data <- system.file("extdata", "GSE117751_RAW", package = "NanoTube")

# First file only
single_file <- list.files(example_data, full.names = TRUE)[1]
single_dat <- read_rcc(single_file)
}
