% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight_by_delta.R
\name{weight_by_delta}
\alias{weight_by_delta}
\title{Find sum of weights for the LaGrange multiplier}
\usage{
weight_by_delta(delta, alpha = 0.05, et, m, m1, tail = 1L, ranksProb,
  effectType = c("continuous", "binary"))
}
\arguments{
\item{delta}{Numeric value of the LagRange multiplier}

\item{alpha}{Numeric, significance level of the hypothesis test}

\item{et}{Numeric, mean effect size of the test statistics}

\item{m}{Integer, totoal number of hypothesis test}

\item{m1}{Integer, number of true alternative tests}

\item{tail}{Integer (1 or 2), right-tailed or two-tailed hypothesis test.
default is right-tailed test.}

\item{ranksProb}{Numeric vector of the ranks probability of the filter
statistics given the effect size}

\item{effectType}{Character ("continuous" or "binary"), type of effect sizes}
}
\value{
\code{sumWeight_per_delta} sum of weights per delta value
}
\description{
Compute sum of weights for a given value of the LaGrange multiplier
}
\details{
To obtain the normalized weight, and to make sure that the sum of the weights is
equal to the number of tests and the weights are positive, an optimal value of the
LaGrange multiplier \code{delta} needed. This function will compute the weights for a given
value of the LaGrange multiplier and provide the sum of the weights in return.
}
\examples{

# generate a sequence of delta
delta <- seq(0, 1, .0001)

# compute probability fiven effect
filters = runif(100, min = 0, max = 2.5)
probs <- dnorm(filters, mean = 0, sd = 1)

# compute the sum of weights for each delta
weightSum_by_delta <- sapply(delta, weight_by_delta, m = 100, m1 = 50, et = 2,
                            ranksProb = probs, effectType = "continuous")

}
\author{
Mohamad S. Hasan, shakilmohamad7@gmail.com
}
