% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STAR.R
\name{STAR.index}
\alias{STAR.index}
\title{Create STAR genome index}
\usage{
STAR.index(
  arguments,
  output.dir = paste0(dirname(arguments[1]), "/STAR_index/"),
  star.path = STAR.install(),
  max.cpus = min(90, BiocParallel::bpparam()$workers),
  max.ram = 30,
  SAsparse = 1,
  tmpDirStar = "-",
  remake = FALSE,
  script = system.file("STAR_Aligner", "STAR_MAKE_INDEX.sh", package = "ORFik"),
  notify_load_existing = TRUE
)
}
\arguments{
\item{arguments}{a named character vector containing paths wanted to
use for index creation. They must be named correctly:
names must be a subset of:
c("gtf", "genome", "contaminants", "phix", "rRNA", "tRNA","ncRNA")}

\item{output.dir}{directory to save indices, default:
paste0(dirname(arguments[1]), "/STAR_index/"), where arguments is the
arguments input for this function.}

\item{star.path}{path to STAR, default: STAR.install(),
if you don't have STAR installed at default location, it will install it there,
set path to a runnable star if you already have it.}

\item{max.cpus}{integer, default: \code{min(90, BiocParallel:::bpparam()$workers)},
number of threads to use. Default is minimum of 90 and maximum cores - 2. So if you
have 8 cores it will use 6. Note: FASTP will use maximum 16 threads as from testing
I see performance actually degrades using anything higher. From testing I also see
STAR gets no performance gain after ~50 threads. I do suspect this will change
when hard drives gets better in the future.}

\item{max.ram}{integer, default 30, in Giga Bytes (GB).
Maximum amount of RAM allowed for STAR limitGenomeGenerateRAM argument. RULE:
idealy 10x genome size, but do not set too close to machine limit. Default fits
well for human genome size (3 GB * 10 = 30 GB)}

\item{SAsparse}{int > 0,  default 1. If you do not have at least 64GB RAM,
you might need to set this to 2.
suffux array sparsity, i.e.  distance between indices:
use bigger numbers to decrease needed RAM at the cost of mapping
speed reduction. Only applies to genome, not conaminants.}

\item{tmpDirStar}{character, default "-". STAR automatic temp folder creation,
deleted when done. The directory can not exists, as a safety STAR must make it!.
If you are on a NFS file share drive, and you have a non NFS tmp dir,
set this to \code{tempfile()} or the manually specified folder to get a
considerable speedup!}

\item{remake}{logical, default: FALSE, if TRUE remake everything specified}

\item{script}{location of STAR index script,
default internal ORFik file. You can change it and give your own if you
need special alignments.}

\item{notify_load_existing}{logical, default TRUE. If annotation exists
(defined as: locally (a file called outputs.rds) exists in outputdir),
print a small message notifying the user it is not redownloading. Set to
FALSE, if this is not wanted}
}
\value{
output.dir, can be used as as input for STAR.align..
}
\description{
Used as reference when aligning data \cr
Get genome and gtf by running getGenomeAndFasta()
}
\details{
Can only run on unix systems (Linux and Mac), and requires
minimum 30GB memory on genomes like human, rat, zebrafish etc.\cr
If for some reason the internal STAR index bash script will not work for you,
like if you have a very small genome. You can copy the internal index script,
edit it and give that as the Index script used for this function.
It is recommended to run through the RStudio local job tab, to give full info
about the run. The system console will not stall, as can happen in happen in
normal RStudio console.
}
\examples{
## Manual way, specify all paths yourself.
#arguments <- c(path.GTF, path.genome, path.phix, path.rrna, path.trna, path.ncrna)
#names(arguments) <- c("gtf", "genome", "phix", "rRNA", "tRNA","ncRNA")
#STAR.index(arguments, "output.dir")

## Or use ORFik way:
output.dir <- "/Bio_data/references/Human"
# arguments <- getGenomeAndAnnotation("Homo sapiens", output.dir)
# STAR.index(arguments, output.dir)
}
\seealso{
Other STAR: 
\code{\link{STAR.align.folder}()},
\code{\link{STAR.align.single}()},
\code{\link{STAR.allsteps.multiQC}()},
\code{\link{STAR.install}()},
\code{\link{STAR.multiQC}()},
\code{\link{STAR.remove.crashed.genome}()},
\code{\link{getGenomeAndAnnotation}()},
\code{\link{install.fastp}()}
}
\concept{STAR}
