% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_class.R
\name{model.matrix,experiment-method}
\alias{model.matrix,experiment-method}
\title{Get experiment design model matrix}
\usage{
\S4method{model.matrix}{experiment}(object, design_formula = design(object, as.formula = TRUE))
}
\arguments{
\item{object}{an ORFik \code{\link{experiment}}}

\item{design_formula}{the experiment design, as formula, subset columns, to
change the model.matrix, default: \code{design(object, as.formula = TRUE)}}
}
\value{
a matrix with design and level attributes
}
\description{
The function extends stats::model.matrix.
}
\examples{
df <- ORFik.template.experiment()
model.matrix(df) # Single factor, default
model.matrix(df, design(df, as.formula = TRUE, multi.factor = TRUE))
}
