% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_plots.R
\name{rnaNormalize}
\alias{rnaNormalize}
\title{Normalize a data.table of coverage by RNA seq per position}
\usage{
rnaNormalize(coverage, df, dfr = NULL, tx, normalizeMode = "position")
}
\arguments{
\item{coverage}{a data.table containing at least columns (count/score,
position), it is possible to have additionals: (genes, fraction, feature)}

\item{df}{an ORFik \code{\link{experiment}}}

\item{dfr}{an ORFik \code{\link{experiment}} of RNA-seq to
normalize against. Will add RNA normalized to plot name if this is done.}

\item{tx}{a \code{\link{GRangesList}} of mrna transcripts}

\item{normalizeMode}{a character (default: "position"), how to normalize
library against rna library. Either on "position", normalize by
number of genes, sum of reads and RNA seq, on tx "region" or "feature":
same as position but RNA is split into the feature groups to normalize.
Useful if you have a list of targets and background genes.}
}
\value{
a data.table of normalized transcripts by RNA.
}
\description{
Normalizes per position per gene by this function:
(reads at position / min(librarysize, 1) * number of genes) /
 fpkm of that gene's RNA-seq
}
\details{
Good way to compare libraries
}
