% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-results.R
\name{results}
\alias{results}
\alias{results,OutriderDataSet-method}
\title{Accessor function for the 'results' object in an OutriderDataSet object.}
\usage{
results(object, ...)

\S4method{results}{OutriderDataSet}(
  object,
  padjCutoff = 0.05,
  zScoreCutoff = 0,
  round = 2,
  all = FALSE,
  returnTranscriptomewideResults = TRUE,
  ...
)
}
\arguments{
\item{object}{An OutriderDataSet object}

\item{...}{Additional arguments, currently not used}

\item{padjCutoff}{The significant threshold to be applied}

\item{zScoreCutoff}{If provided additionally a z score threshold is applied}

\item{round}{Can be TRUE, defaults to 2, or an integer used for rounding
with \code{\link[base]{round}} to make the output
more user friendly}

\item{all}{By default FALSE, only significant read counts are listed in the 
results. If TRUE all results are assembled resulting in a 
data.table of length samples x genes.}

\item{returnTranscriptomewideResults}{If FDR corrected pvalues for subsets 
of genes of interest have been calculated, this parameter 
indicates whether additionally the transcriptome-wide results 
should be returned as well (default), or whether only results 
for those subsets should be retrieved.}
}
\value{
A data.table where each row is an outlier event and the columns
   contain additional information about this event. In details the 
   table contains: 
   \item{sampleID/geneID}{The gene or sample ID as provided by the 
         user, e.g. \code{rowData(ods)} and \code{colData(ods)},
         respectively.}
   \item{pValue/padjust}{The nominal P-value and the FDR corrected
         P-value (transcriptome-wide) indicating the outlier status.}
   \item{zScore/l2fc}{The z score and log\eqn{_2}{[2]} fold change 
       as computed by \code{\link[OUTRIDER]{computeZscores}}.}
   \item{rawcounts}{The observed read counts.}
   \item{normcounts}{The expected count given the fitted 
         autoencoder model for the given gene-sample combination.}
   \item{meanRawcounts/meanCorrected}{For this gene, the mean of the 
        observed or expected counts, respectively, given the fitted 
        autoencoder model.}
   \item{theta}{The dispersion parameter of the NB distribution 
         for the given gene.}
   \item{aberrant}{The transcriptome-wide outlier status of this event: 
         \code{TRUE} or \code{FALSE}.}
   \item{AberrantBySample/AberrantByGene}{Number of outliers for the 
         given sample or gene (transcriptome-wide), respectively.}
   \item{padj_rank}{Rank of this outlier event within the given sample.}
   \item{padjust_FDRset}{The FDR corrected P-value with respect to the 
         gene subset called 'FDRset', if gene subsets were specified 
         during the P-value computation. Find more details at 
         \code{\link[OUTRIDER]{computePvalues}}.}
}
\description{
This function assembles a results table of significant outlier events based
on the given filter criteria. The table contains various information 
accumulated over the analysis pipeline.
}
\examples{

ods <- makeExampleOutriderDataSet()
\dontshow{
    ods <- ods[1:10,1:10]
}
ods <- OUTRIDER(ods)

res <- results(ods, all=TRUE)
res

# example of retrieving results with FDR correction limited to a 
# set of genes of interest
genesOfInterest <- list("sample_1"=sample(rownames(ods), 3), 
                         "sample_2"=sample(rownames(ods), 8), 
                         "sample_6"=sample(rownames(ods), 5))
genesOfInterest
ods <- computePvalues(ods, subsets=list("exampleSubset"=genesOfInterest))
res <- results(ods, all=TRUE, returnTranscriptomewideResults=FALSE)
res

}
