#' 
#' generate test object to test for
#' 
get_test_outrider_dataset <- function(){
    ###
    ### GIVEN DATA
    ###
    
    # raw count data
    cts <- matrix(byrow=TRUE, nrow=3, as.integer(c(
        c( 4,  1,  8,  1,  9,  3,  0,  1,  1,  3,  1,  9, 25,  6,  1),
        c(15, 21, 18,  8, 16, 25, 12, 22, 28,  6, 10, 31, 10, 11,  6),
        c(15, 17, 32, 10, 23, 32,  8,  6, 58, 20, 11, 12,  8, 24, 12))))
    
    # size factors
    sizeF_round3 <- c(0.925, 0.974, 0.889, 0.950, 0.943, 1.010, 1.023, 1.130,
                      1.100, 0.999, 0.866, 1.152, 0.805, 1.174, 1.120)
    
    # normalization factors
    normF_round3 <- matrix(byrow=TRUE, nrow=3, c(
            c(5.081, 4.144, 3.404, 5.363, 5.417, 3.051, 5.807, 7.005, 1.539,
                    4.77, 4.525, 8.746, 25.449, 6.138, 6.328), 
            c(16.154, 21.095, 14.375, 14.358, 14.614, 21.426, 17.703, 24.703,
                    21.909, 12.816, 14.186, 27.028, 7.99, 16.016, 15.449), 
            c(16.517, 19.272, 20.829, 14.532, 18.293, 24.575, 15.893, 18.745,
                    35.395, 16.473, 14.167, 21.622, 10.986, 20.109, 16.512)))
    
    
    ###
    ### EXPECTED
    ###
    
    # fit
    mu_round4 <- c(0.723, 0.9103, 0.9661)
    disp_round4 <- c(2.0051, 31.3601, 8.5276)
    
    # pvalues
    pval_round4 <- matrix(byrow=TRUE, nrow=3, c(
        c(0.8474, 0.7044, 0.0785, 0.5365, 0.1971, 0.7003, 0.2077, 0.3895,
                1.0000, 1.0000, 0.6446, 0.5332, 0.5230, 0.6146, 0.4419),
        c(0.9795, 0.7672, 0.3036, 0.2792, 0.5769, 0.3648, 0.4826, 1.0000,
                0.1980, 0.1723, 0.6053, 0.3644, 0.4334, 0.5296, 0.0626),
        c(1.0000, 0.9756, 0.1865, 0.6134, 0.4681, 0.3870, 0.2763, 0.0649,
                0.1055, 0.5376, 0.7921, 0.3118, 0.7373, 0.5501, 0.6710)))
    
    # padj
    padj_round4 <- matrix(byrow=TRUE, nrow=3, c(
        c(1.0000, 0.9756, 0.2356, 0.6134, 0.5769, 0.7003, 0.4144, 0.5842,
                1.0000, 1.0000, 0.7921, 0.5332, 0.7373, 0.6146, 0.6629),
        c(1.0000, 0.9756, 0.3036, 0.6134, 0.5769, 0.5805, 0.4826, 1.0000,
                0.297, 0.5168, 0.7921, 0.5332, 0.7373, 0.6146, 0.1877),
        c(1.0000, 0.9756, 0.2798, 0.6134, 0.5769, 0.5805, 0.4144, 0.1948,
                0.297, 0.8063, 0.7921, 0.5332, 0.7373, 0.6146, 0.671)))
    
    # zscores
    zscore_round4 <- matrix(byrow=TRUE, nrow=3, c(
        c(0.3661, -0.5562, 1.6456, -0.8901, 1.1806, 0.7375, -1.8904, -1.2359,
                0.7261, 0.159, -0.6701, 0.5604, 0.4146, 0.557, -1.1043),
        c(0.2341, 0.3828, 1.0658, -1.0847, 0.6976, 0.8194, -0.6284, 0.0558,
                1.07, -1.4817, -0.4715, 0.7485, 1.1833, -0.5705, -2.0203),
        c(0.0914, 0.0037, 1.273, -0.5011, 0.8199, 0.8757, -1.1981, -2.1981, 
                1.395, 0.7509, -0.231, -1.0542, -0.3112, 0.6906, -0.4066)))
    
    
    ###
    ### SET DATA
    ###
    ods <- OutriderDataSet(countData=getCountDataWithNames(cts))
    
    sizeFactors(ods) <- sizeF_round3
    normalizationFactors(ods) <- normF_round3
    mcols(ods)[['mu']] <- mu_round4
    mcols(ods)[['disp']] <- disp_round4
    assay(ods, 'pValue', withDimnames=FALSE)  <- pval_round4
    assay(ods, 'padjust', withDimnames=FALSE) <- padj_round4
    assay(ods, 'zScore', withDimnames=FALSE)  <- zscore_round4
    
    return(ods)
}

getCountDataWithNames <- function(cts){
    colnames(cts) <- paste0('sample_', seq_col(cts))
    rownames(cts) <- paste0('gene', seq_row(cts))
    return(cts)
}
