% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatTopGO.R
\name{formatTopGO}
\alias{formatTopGO}
\title{Format the GO annotations data}
\usage{
formatTopGO(geneList, format)
}
\arguments{
\item{geneList}{the list of OmaDB protein objects or a dataframe of ontologies to be included in the analysis - this is where the GO annotations are extracted from.}

\item{format}{format for the data to be returned in - either 'GO2geneID' or 'geneID2GO'}
}
\value{
a list containing the GO2geneID or geneID2GO information
}
\description{
The function to create a list of GO annotations that is compatible with topGO from protein objects in roma
}
\examples{
geneList = list(getProtein(id='YEAST01'),getProtein(id='YEAST03'))
annotations = formatTopGO(geneList,format='geneID2GO')
}
