% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{omnipath_cache_download_ready}
\alias{omnipath_cache_download_ready}
\title{Sets the download status to ready for a cache item}
\usage{
omnipath_cache_download_ready(version, key = NULL)
}
\arguments{
\item{version}{Version of the cache item. If does not exist a new version
item will be created}

\item{key}{Key of the cache item}
}
\value{
Character: invisibly returns the version number of the cache
    version item.
}
\description{
Sets the download status to ready for a cache item
}
\examples{
bioc_url <- 'https://bioconductor.org/'
# request a new version item (or retrieve the latest)
new_version <- omnipath_cache_latest_or_new(url = bioc_url)
# check if the version item is not a finished download
new_version$status
# [1] "unknown"
# download the file
curl::curl_fetch_disk(bioc_url, new_version$path)
# report to the cache database that the download is ready
omnipath_cache_download_ready(new_version)
# now the status is ready:
version <- omnipath_cache_latest_or_new(url = bioc_url)
version$status
# "ready"
version$dl_finished
# [1] "2021-03-09 16:48:38 CET"
omnipath_cache_remove(url = bioc_url) # cleaning up

}
