% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{omnipath_cache_latest_or_new}
\alias{omnipath_cache_latest_or_new}
\title{The latest or a new version of a cache record}
\usage{
omnipath_cache_latest_or_new(
  key = NULL,
  url = NULL,
  post = NULL,
  payload = NULL,
  create = TRUE,
  ...
)
}
\arguments{
\item{key}{The key of the cache record}

\item{url}{URL pointing to the resource}

\item{post}{HTTP POST parameters as a list}

\item{payload}{HTTP data payload}

\item{create}{Logical: whether to create and return a new version. If
FALSE only the latest existing valid version is returned, if available.}

\item{...}{Passed to \code{\link{omnipath_cache_get}}}
}
\value{
A cache version item.
}
\description{
Looks up a record in the cache and returns its latest valid version. If
the record doesn't exist or no valid version available, creates a new one.
}
\examples{
\dontrun{
# retrieve the latest version of the first cache record
# found by the search keyword "bioplex"
latest_bioplex <-
    omnipath_cache_latest_or_new(
        names(omnipath_cache_search('bioplex'))[1]
    )

latest_bioplex$dl_finished
# [1] "2021-03-09 14:28:50 CET"
latest_bioplex$path
# [1] "/home/denes/.cache/OmnipathR/378e0def2ac97985f629-1.rds"
}

# create an example cache record
bioc_url <- 'https://bioconductor.org/'
version <- omnipath_cache_latest_or_new(url = bioc_url)
omnipath_cache_remove(url = bioc_url) # cleaning up

}
