% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bma.R
\name{print_bma_motif_es}
\alias{print_bma_motif_es}
\title{Prints BMA motifs to the screen from a sequence of edges}
\usage{
print_bma_motif_es(edge_seq, G, granularity = 2)
}
\arguments{
\item{edge_seq}{An igraph edge sequence.}

\item{G}{An igraph graph object.}

\item{granularity}{Numeric: granularity value.}
}
\value{
Returns `NULL`.
}
\description{
The motifs can be copy-pasted into a BMA canvas.
}
\examples{
interactions <- omnipath(resources = "ARN")
graph <- interaction_graph(interactions)
print_bma_motif_es(igraph::E(graph)[1], graph)
# {"Model": {
#     "Name": "Omnipath motif",
#     "Variables":[{
#         "Name":"ULK1",
#         "Id":1,
#         "RangeFrom":0,
#         "RangeTo":2,
#         "Formula":""
#     },
#     {
#         "Name":"ATG13",
#         ...
#     }],
# ... (truncated)
# }}

}
