% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ontology.R
\name{descendants}
\alias{descendants}
\title{All descendants in the ontology tree}
\usage{
descendants(
  terms,
  db_key = "go_basic",
  ids = TRUE,
  relations = c("is_a", "part_of", "occurs_in", "regulates", "positively_regulates",
    "negatively_regulates")
)
}
\arguments{
\item{terms}{Character vector of ontology term IDs or names. A mixture of
IDs and names can be provided.}

\item{db_key}{Character: key to identify the ontology database. For the
available keys see \code{\link{omnipath_show_db}}.}

\item{ids}{Logical: whether to return IDs or term names.}

\item{relations}{Character vector of ontology relation types. Only these
relations will be used.}
}
\value{
Character vector of ontology IDs. If the input terms are all
    leaves \code{NULL} is returned. The starting nodes won't be included
    in the result unless some of them are descendants of other starting
    nodes.
}
\description{
Starting from the selected nodes, recursively walks the ontology tree
until it reaches the leaf nodes. Collects all visited nodes, which are
the descendants (children) of the starting nodes.
}
\details{
Note: this function relies on the database manager, the first call might
take long because of the database load process. Subsequent calls within
a short period should be faster. See \code{\link{get_ontology_db}}.
}
\examples{
descendants('GO:0005035', ids = FALSE)
# [1] "tumor necrosis factor-activated receptor activity"
# [2] "TRAIL receptor activity"
# [3] "TNFSF11 receptor activity"

}
