% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{ensembl_name}
\alias{ensembl_name}
\title{Ensembl identifiers of organisms}
\usage{
ensembl_name(name)
}
\arguments{
\item{name}{Vector with any kind of organism name or identifier, can be
also mixed type.}
}
\value{
Character vector with Ensembl taxon names, NA if a name
    in the input could not be found.
}
\description{
Ensembl identifiers of organisms
}
\examples{
ensembl_name(c(9606, "cat", "dog"))
# [1] "hsapiens" "fcatus" "clfamiliaris"
ensembl_name(c("human", "kitten", "cow"))
# [1] "hsapiens" NA  "btaurus"

}
\seealso{
\itemize{
    \item{\code{\link{ncbi_taxid}}}
    \item{\code{\link{common_name}}}
    \item{\code{\link{latin_name}}}
}
}
