% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/homologene.R
\name{homologene_raw}
\alias{homologene_raw}
\title{Orthology data from NCBI HomoloGene}
\usage{
homologene_raw()
}
\value{
A data frame as provided by NCBI HomoloGene.
}
\description{
Retrieves NCBI HomoloGene data without any processing. Processed tables
are more useful for most purposes, see below other functions that provide
those. Genes of various organisms are grouped into homology groups
("hgroup" column). Organisms are identified by NCBI Taxonomy IDs, genes
are identified by four different identifier types.
}
\examples{
hg <- homologene_raw()
hg
# # A tibble: 275,237 × 6
#    hgroup ncbi_taxid entrez  genesymbol  gi        refseqp
#     <int>      <int> <chr>   <chr>       <chr>     <chr>
#  1      3       9606 34      ACADM       4557231   NP_000007.1
#  2      3       9598 469356  ACADM       160961497 NP_001104286.1
#  3      3       9544 705168  ACADM       109008502 XP_001101274.1
#  4      3       9615 490207  ACADM       545503811 XP_005622188.1
#  5      3       9913 505968  ACADM       115497690 NP_001068703.1
# # . with 275,232 more rows

# which organisms are available?
common_name(unique(hg$ncbi_taxid))
#  [1] "Human" "Chimpanzee" "Macaque" "Dog" "Cow" "Mouse" "Rat" "Zebrafish"
#  [9] "D. melanogaster" "Caenorhabditis elegans (PRJNA13758)"
# [11] "Tropical clawed frog" "Chicken"
# ...and 9 more organisms with missing English names.

}
\seealso{
\itemize{
    \item{\code{\link{homologene_download}}}
}
}
