% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{omnipath_cache_filter_versions}
\alias{omnipath_cache_filter_versions}
\title{Filters the versions from one cache record}
\usage{
omnipath_cache_filter_versions(
  record,
  latest = FALSE,
  max_age = NULL,
  min_age = NULL,
  status = CACHE_STATUS$READY
)
}
\arguments{
\item{record}{A cache record}

\item{latest}{Return the most recent version}

\item{max_age}{The maximum age in days (e.g. 5: 5 days old or more recent)}

\item{min_age}{The minimum age in days (e.g. 5: 5 days old or older)}

\item{status}{Character vector with status codes. By default only the
versions with `ready` (completed download) status are selected}
}
\value{
Character vector with version IDs, NA if no version satisfies the
    conditions.
}
\description{
Filters the versions based on multiple conditions: their age and status
}
\examples{
# creating an example cache record
bioc_url <- 'https://bioconductor.org/'
version <- omnipath_cache_latest_or_new(url = bioc_url)
curl::curl_fetch_disk(bioc_url, version$path)
omnipath_cache_download_ready(version)
record <- dplyr::first(omnipath_cache_search('biocond'))

# only the versions with status "ready"
version_numbers <- omnipath_cache_filter_versions(record, status = 'ready')
omnipath_cache_remove(url = bioc_url) # cleaning up

}
