% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{omnipath_cache_get}
\alias{omnipath_cache_get}
\title{Retrieves one item from the cache directory}
\usage{
omnipath_cache_get(
  key = NULL,
  url = NULL,
  post = NULL,
  payload = NULL,
  create = TRUE,
  ...
)
}
\arguments{
\item{key}{The key of the cache record}

\item{url}{URL pointing to the resource}

\item{post}{HTTP POST parameters as a list}

\item{payload}{HTTP data payload}

\item{create}{Create a new entry if doesn't exist yet}

\item{...}{Passed to \code{omnipath_cache_record} (internal function)}
}
\value{
Cache record: an existing record if the entry already exists,
    otherwise a newly created and inserted record
}
\description{
Retrieves one item from the cache directory
}
\examples{
# create an example cache record
bioc_url <- 'https://bioconductor.org/'
version <- omnipath_cache_latest_or_new(url = bioc_url)
omnipath_cache_remove(url = bioc_url) # cleaning up

# retrieve the cache record
record <- omnipath_cache_get(url = bioc_url)
record$key
# [1] "41346a00fb20d2a9df03aa70cf4d50bf88ab154a"
record$url
# [1] "https://bioconductor.org/"

}
