% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{PDseDataSetFromMat}
\alias{PDseDataSetFromMat}
\title{PDseDataSet from rMATs/PAIRADISE Mat format}
\usage{
PDseDataSetFromMat(dat)
}
\arguments{
\item{dat}{The Mat format dataframe.}
}
\value{
A PDseDataSet object
}
\description{
The Mat format should have 7 columns, arranged as follows: Column 1
contains the ID of the alternative splicing events.  Column 2
contains counts of isoform 1 corresponding to the first group.
Column 3 contains counts of isoform 2 corresponding to the first
group.  Column 4 contains counts of isoform 1 corresponding to the
second group.  Column 5 contains counts of isoform 2 corresponding
to the second group.  Column 6 contains the effective length of
isoform 1.  Column 7 contains the effective length of isoform 2.
Replicates in columns 2-5 should be separated by commas,
e.g. "1623,432,6" for three replicates and the replicate order
should be consistent for each column to ensure pairs are matched
correctly.
}
\examples{
data("sample_dataset")
pdat <- PDseDataSetFromMat(sample_dataset)
}
