% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDoc.R
\docType{data}
\name{hp_descendants}
\alias{hp_descendants}
\title{HP descendants (Example data)}
\format{A named list of 10962 character vectors.}
\source{
\url{http://compbio.charite.de/hudson/job/hpo/1529/artifact/hp/hp.obo}
}
\description{
HP terms which are descendants of each HP term
(including itself) in the Human Phenotype Ontology
(\url{http://www.human-phenotype-ontology.org/}).
Only descendants of 'Phenotypic abnormality' were taken into account.
}
\details{
These data are used to examplify the different functions of
the package.
More data are available in the MultiHumanPhenoDB package.
}
\examples{
###########################################
## Compute information content of each HP according to associated genes
data(geneByHp, hp_descendants, package="PCAN")
geneByHp <- unstack(geneByHp, entrez~hp)
ic <- computeHpIC(geneByHp, hp_descendants)
hist(
    ic,
    breaks=100, col="grey",
    main="Distribution of Information Content",
    xlab="IC base on genes associated to HP"
)
}

