% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIUMA_Clustering.R
\name{autoClusterMapper}
\alias{autoClusterMapper}
\title{Automatic Clustering of a Mapper Graph by Predicted Geometry
(with kNN tie-break)}
\usage{
autoClusterMapper(
  x,
  method = c("automatic", "fast_greedy", "walktrap", "edge_betweenness", "optimal",
    "label_propagation"),
  k = 5L
)
}
\arguments{
\item{x}{A \code{TDAobj} with \code{x@graph$igraph} and
\code{x@graph$predicted$class} set.}

\item{method}{One of \code{"automatic","fast_greedy","walktrap",
"edge_betweenness","optimal","label_propagation"}.
Default \code{"automatic"}.}

\item{k}{Integer >=1 or \code{FALSE}. Default \code{5L}. If numeric, use
k-NN mean distance to break ties; if \code{FALSE}, concatenate
topological labels (e.g. "2_8", "1_2_3").}
}
\value{
The input \code{TDAobj} \emph{invisibly}, with \code{x@clustering}
updated:
\describe{
  \item{\code{nodes_cluster}}{Data frame with columns \code{node},
  \code{obs}, \code{cluster}.}
  \item{\code{obs_cluster}}{Data frame with columns \code{obs},
  \code{cluster}.}
}
}
\description{
Cluster Mapper nodes (x@graph$igraph) with a chosen community algorithm or
an automatic selection based on predicted graph geometry
(x@graph$predicted).
Assign observations either by k-NN tie-breaking (default) or by pure
topological label concatenation.
}
\details{
In \code{method = "automatic"}, the algorithm is chosen from the
predicted geometry:
\describe{
  \item{\code{SF} / \code{CM}}{Use \emph{fast greedy} modularity
  optimization.}
  \item{\code{WS}}{Use \emph{Walktrap} (short random walks).}
  \item{\code{RGG}}{Use \emph{edge betweenness} (bridge detection).}
  \item{\code{SBM}}{Prefer \emph{optimal} (exact modularity) for small
  graphs; falls back for larger ones.}
  \item{\code{ER}}{Use \emph{label propagation} (fast, parameter-free).}
}
Isolated nodes (degree = 0) become singletons with unique labels.
}
\examples{
data(vascEC_norm)
data(vascEC_meta)
#df_TDA <- cbind(vascEC_meta, vascEC_norm)
#df_TDA <- makeTDAobj(df_TDA,outcomes = c("stage","zone"))
#df_TDA <- dfToDistance(df_TDA,'euclidean')
#df_TDA <- dfToProjection(df_TDA, "UMAP", nComp = 2)
#df_TDA <- mapperCore(df_TDA,
 #         nBins = 20, overlap = 0.3,
 #         mClustNode = 2, clustMeth = "kmeans")
#df_TDA <- jaccardMatrix(df_TDA)
#df_TDA <- setGraph(df_TDA)
#df_TDA <- predict_mapper_class(df_TDA)
#df_TDA <- autoClusterMapper(df_TDA,method = 'walktrap')

}
\seealso{
\code{\link{mapperCore}}
}
\author{
Carlo Leonardi, Mattia Chiesa
}
