% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIUMA_Projection.R
\name{dfToProjection}
\alias{dfToProjection}
\title{Data projection using a Dimensionality Reduction Method}
\usage{
dfToProjection(
  x,
  method = c("PCA", "UMAP", "TSNE", "MDS", "KPCA", "ISOMAP"),
  nComp = 2,
  centerPCA = FALSE,
  scalePCA = FALSE,
  umapNNeigh = 15,
  umapMinDist = 0.1,
  tsnePerpl = 30,
  tsneMaxIter = 300,
  kpcaKernel = c("rbfdot", "laplacedot", "polydot", "tanhdot", "besseldot", "anovadot",
    "vanilladot", "splinedot"),
  kpcaSigma = 0.1,
  kpcaDegree = 1,
  isomNNeigh = 5,
  showPlot = FALSE,
  vectColor = NULL
)
}
\arguments{
\item{x}{A TDAobj object, generated by \link{makeTDAobj}}

\item{method}{Name of the dimensionality reduction method to use.
"PCA", "UMAP", "TSNE", "MDS", "KPCA" and "isomap" values are allowed.
Default is: "PCA".}

\item{nComp}{The number of components to be computed. Default: 2}

\item{centerPCA}{Whether the data should be centered before PCA. Default:TRUE}

\item{scalePCA}{Whether the data should be scaled before PCA. Default:TRUE}

\item{umapNNeigh}{The number of neighbors for UMAP. Default: 15}

\item{umapMinDist}{The minimum distance between points for UMAP. Default: 0.1}

\item{tsnePerpl}{Perplexity argument of t-SNE. Default: 30}

\item{tsneMaxIter}{The maximum number of iterations for t-SNE. Default: 300}

\item{kpcaKernel}{The type of kernel for kPCA. "rbfdot", "laplacedot",
"polydot", "tanhdot", "besseldot", "anovadot", "vanilladot" and "splinedot"
 are allowed. Default: "polydot".}

\item{kpcaSigma}{The 'sigma' argument for kPCA. Default: 0.1.}

\item{kpcaDegree}{The 'degree' argument for kPCA. Default: 1.}

\item{isomNNeigh}{The number of neighbors for Isomap. Default: 5.}

\item{showPlot}{Whether the scatter plot of the first two
principal components should be shown. Default: TRUE.}

\item{vectColor}{Vector containing the variable tocolor the scatter plot
Default: NULL.}
}
\value{
The starting TDAobj object, in which the principal components of
projected data have been added (slot:'comp')
}
\description{
This function performs the transformation of data from a
high dimensional space into a low dimensional space, wrapping 6 well-knwon
 reduction methods; i.e., PCA, KPCA, t-SNE, UMAP, MDS, and Isomap.
 In the topological data analysis, the identified components are commonly
 used as lenses.
}
\examples{
data(vascEC_norm)
data(vascEC_meta)
df_TDA <- cbind(vascEC_meta, vascEC_norm)
df_TDA <- makeTDAobj(df_TDA,outcomes = c("stage","zone"))
df_TDA <- dfToProjection(df_TDA,'PCA',nComp=2)

}
\seealso{
\code{\link{makeTDAobj}},
\code{\link{dfToDistance}}
}
\author{
Mattia Chiesa, Laura Ballarini, Luca Piacentini
}
