% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaClust.R
\name{PomaClust}
\alias{PomaClust}
\title{Cluster Analysis}
\usage{
PomaClust(
  data,
  method = "euclidean",
  k = NA,
  k_max = floor(min(dim(data))/2),
  show_clusters = TRUE,
  labels = FALSE
)
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{method}{Character. Indicates the distance method to perform MDS. Options are "euclidean", "maximum", "manhattan", "canberra" and "minkowski". See \code{?dist()}.}

\item{k}{Numeric. Indicates the number of clusters (default is \code{NA}). The optimal number of clusters will be used by default.}

\item{k_max}{Numeric. Indicates the number of clusters among which the optimal \code{k} will be selected.}

\item{show_clusters}{Logical. Indicates if clusters should be plotted or not.}

\item{labels}{Logical. Indicates if sample names should be plotted or not.}
}
\value{
A \code{list} with results including plots and tables.
}
\description{
\code{PomaClust} performs a k-means clustering and plots the results in a classical multidimensional scaling (MDS) plot.
}
\examples{
## Output is a list with objects `mds_coordinates` (tibble), `mds_plot` (ggplot2 object), `optimal_clusters_number` (numeric value), `optimal_clusters_number` (numeric value), and `optimal_clusters_plot` (ggplot2 object)
data <- POMA::st000284 # Example SummarizedExperiment object included in POMA

data \%>\% 
  PomaClust(method = "euclidean",
            k = NA,
            k_max = floor(min(dim(data))/2), 
            show_clusters = TRUE,
            labels = FALSE)
}
\author{
Pol Castellano-Escuder
}
