% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaCreateObject.R
\name{PomaCreateObject}
\alias{PomaCreateObject}
\title{Create a \code{SummarizedExperiment} Object}
\usage{
PomaCreateObject(metadata = NULL, features = NULL, factor_levels = 10)
}
\arguments{
\item{metadata}{Data frame. Metadata variables structured in columns. Sample ID must be the first column.}

\item{features}{Matrix of features. Each feature is a column.}

\item{factor_levels}{Numeric. Integer variables with less levels than indicated by this parameter will be treated as factors.}
}
\value{
A \code{SummarizedExperiment} object.
}
\description{
\code{PomaCreateObject} creates a \code{SummarizedExperiment} object from data frames.
}
\examples{
data(iris)

# Create metadata: Data frame with sample names and a group factor
metadata <- data.frame(sample_id = paste0("sample_", 1:150), group = iris$Species)

# Create features: `p` column data frame with features
features <- iris[, 1:4]

# Create a `SummarizedExperiment` object with `POMA`
object <- PomaCreateObject(metadata = metadata, 
                           features = features)
}
\references{
Morgan M, Obenchain V, Hester J, Pagès H (2021). SummarizedExperiment: SummarizedExperiment container. R package version 1.24.0, https://bioconductor.org/packages/SummarizedExperiment.
}
\author{
Pol Castellano-Escuder
}
