% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaLimma.R
\name{PomaLimma}
\alias{PomaLimma}
\title{Differential Expression Analysis Using \code{limma}}
\usage{
PomaLimma(
  data,
  contrast = NULL,
  outcome = NULL,
  covs = NULL,
  adjust = "fdr",
  block = NULL,
  weights = FALSE
)
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{contrast}{Character. Indicates the comparison. For example, "Group1-Group2" or "control-intervention".}

\item{outcome}{Character. Indicates the name of the \code{colData} column to be used as the outcome factor. Default is NULL (first factor variable in \code{colData}).}

\item{covs}{Character vector. Indicates the names of \code{colData} columns to be included as covariates. Default is NULL (no covariates). If not NULL, a limma model will be fitted using the specified covariates. Note: The order of the covariates is important and should be listed in increasing order of importance in the experimental design.}

\item{adjust}{Character. Indicates the multiple comparisons correction method. Options are: "fdr", "holm", "hochberg", "hommel", "bonferroni", "BH" and "BY".}

\item{block}{Character. Specifies the name of the \code{colData} factor column that includes the random effect variable to be considered (e.g., replicate). The default is NULL, indicating no random effect.}

\item{weights}{Logical. Indicates whether the limma model should estimate the relative quality weights for each group. See \code{?limma::arrayWeights()}.}
}
\value{
A \code{tibble} with the results.
}
\description{
\code{PomaLimma} uses the classical \code{limma} package to compute differential expression analysis.
}
\examples{
data <- POMA::st000284 \%>\% # Example SummarizedExperiment object included in POMA
  PomaNorm()

# Basic limma
limma_results <- data \%>\% 
  PomaLimma(contrast = "Healthy-CRC", 
            covs = NULL,
            adjust = "fdr",
            block = NULL)

limma_results \%>\% 
  dplyr::slice(1:10)

## Volcano plot
limma_results \%>\% 
  dplyr::select(feature, log2FC, pvalue) \%>\% 
  PomaVolcano(labels = TRUE)

## Boxplot of top features
data \%>\% 
  PomaBoxplots(x = "features", 
               outcome = "gender", # factorial variable to group by (e.g., treatment, sex, etc)
               feature_name = limma_results$feature[1:10])

## Heatmap of top features
data[rownames(data) \%in\% limma_results$feature[1:10]] \%>\% 
  PomaHeatmap(covs = c("gender", "smoking_condition", "alcohol_consumption"), # covariates to plot (e.g., treatment, sex, etc)
              feature_names = TRUE)

# Basic limma on alternative outcome
SummarizedExperiment::colData(data)$gender <- factor(ifelse(SummarizedExperiment::colData(data)$gender == 0, "male", "female"))
data \%>\% 
  PomaLimma(contrast = "male-female", 
            outcome = "gender",
            covs = NULL,
            adjust = "fdr",
            block = NULL)

limma_results \%>\% 
  dplyr::slice(1:10)

## Volcano plot
limma_results \%>\% 
  dplyr::select(feature, log2FC, pvalue) \%>\% 
  PomaVolcano(labels = TRUE)

## Boxplot of top features
data \%>\% 
  PomaBoxplots(x = "features", 
               outcome = "gender", # factorial variable to group by (e.g., treatment, sex, etc)
               feature_name = limma_results$feature[1:10])

## Heatmap of top features
data[rownames(data) \%in\% limma_results$feature[1:10]] \%>\% 
  PomaHeatmap(covs = c("gender", "smoking_condition", "alcohol_consumption"), # covariates to plot (e.g., treatment, sex, etc)
              feature_names = TRUE)

# limma with one covariate
data \%>\% 
  PomaLimma(contrast = "Healthy-CRC", 
            covs = "gender",
            adjust = "fdr",
            block = NULL)

limma_results \%>\% 
  dplyr::slice(1:10)

## Volcano plot
limma_results \%>\% 
  dplyr::select(feature, log2FC, pvalue) \%>\% 
  PomaVolcano(labels = TRUE)

## Boxplot of top features
data \%>\% 
  PomaBoxplots(x = "features", 
               outcome = "gender", # factorial variable to group by (e.g., treatment, sex, etc)
               feature_name = limma_results$feature[1:10])

## Heatmap of top features
data[rownames(data) \%in\% limma_results$feature[1:10]] \%>\% 
  PomaHeatmap(covs = c("gender", "smoking_condition", "alcohol_consumption"), # covariates to plot (e.g., treatment, sex, etc)
              feature_names = TRUE)

# limma with two covariates
data \%>\% 
  PomaLimma(contrast = "Healthy-CRC", 
            covs = c("gender", "age_at_consent"),
            adjust = "fdr",
            block = NULL)

limma_results \%>\% 
  dplyr::slice(1:10)

## Volcano plot
limma_results \%>\% 
  dplyr::select(feature, log2FC, pvalue) \%>\% 
  PomaVolcano(labels = TRUE)

## Boxplot of top features
data \%>\% 
  PomaBoxplots(x = "features", 
               outcome = "gender", # factorial variable to group by (e.g., treatment, sex, etc)
               feature_name = limma_results$feature[1:10])

## Heatmap of top features
data[rownames(data) \%in\% limma_results$feature[1:10]] \%>\% 
  PomaHeatmap(covs = c("gender", "smoking_condition", "alcohol_consumption"), # covariates to plot (e.g., treatment, sex, etc)
              feature_names = TRUE)

# limma with replicates
# data \%>\% 
#   PomaLimma(contrast = "Healthy-CRC", 
#             covs = NULL,
#             adjust = "fdr",
#             block = "replicate")
}
\references{
Matthew E. Ritchie, Belinda Phipson, Di Wu, Yifang Hu, Charity W. Law, Wei Shi, Gordon K. Smyth, limma powers differential expression analyses for RNA-sequencing and microarray studies, Nucleic Acids Research, Volume 43, Issue 7, 20 April 2015, Page e47, https://doi.org/10.1093/nar/gkv007
}
\author{
Pol Castellano-Escuder
}
