% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaPCA.R
\name{PomaPCA}
\alias{PomaPCA}
\title{Principal Components Analysis}
\usage{
PomaPCA(
  data,
  outcome = NULL,
  center = TRUE,
  scale = TRUE,
  ncomp = 4,
  labels = FALSE,
  ellipse = FALSE,
  load_length = 1
)
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{outcome}{Character. Indicates the name of the \code{colData} column to be used as the outcome factor. Default is NULL (first factor variable in \code{colData}).}

\item{center}{Logical. Indicates whether the variables should be shifted to be zero centered. Default is TRUE.}

\item{scale}{Logical. Indicates whether the variables should be scaled to have unit variance before the analysis takes place. Default is TRUE.}

\item{ncomp}{Numeric. Number of components to be included in the results. Default is 4.}

\item{labels}{Logical. Indicates if sample names should be displayed.}

\item{ellipse}{Logical. Indicates whether a 95 percent confidence interval ellipse should be displayed in score plot and biplot. Default is FALSE.}

\item{load_length}{Numeric. Indicates the length of biplot loading arrows. Value between 1 and 2. Default is 1.}
}
\value{
A \code{list} with results including plots and tables.
}
\description{
\code{PomaPCA} performs a principal components analysis on the given \code{SummarizedExperiment} object.
}
\examples{
data <- POMA::st000336 \%>\% # Example SummarizedExperiment object included in POMA
  PomaImpute() \%>\% 
  PomaNorm()

## Output is a list with objects `factors` (tibble wth principal components), `eigenvalues` (tibble), `loadings` (tibble), `factors_plot` (ggplot2 object with PCA plot), `eigenvalues_plot` (ggplot2 object with eigenvalues plot), `loadings_plot` (ggplot2 object), and `biplot` (ggplot2 object)
# Default outcome (first factor variable in `colData`)
data \%>\%
  PomaPCA(outcome = NULL,
          center = TRUE,
          scale = TRUE,
          labels = FALSE,
          ellipse = FALSE)

# Alternative outcome
data \%>\%
  PomaPCA(outcome = "steroids",
          center = TRUE,
          scale = TRUE,
          labels = FALSE,
          ellipse = FALSE)
}
\author{
Pol Castellano-Escuder
}
