% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialPathwayAnalysis.R
\name{differentialPathwayAnalysis}
\alias{differentialPathwayAnalysis}
\title{Differential Expression Analysis For Pathways}
\usage{
differentialPathwayAnalysis(
  geneCounts,
  pathways,
  covariates,
  condition,
  adjustCovars = NULL,
  covariateCorrection = FALSE,
  quantileNorm = FALSE,
  outDir = ".",
  saveOutName = NULL,
  id = "ENSEMBL",
  deGenes = NULL,
  minPathSize = 10,
  method = "x2",
  trim = 0.025,
  geneCountsLog = TRUE,
  contrastConds = NA
)
}
\arguments{
\item{geneCounts}{Gene counts, rows refer to genes and columns to samples.}

\item{pathways}{Pathways table, containing pathway names and genes with id
specified.}

\item{covariates}{Covariates/metadata file; rows matches the columns of
geneCounts.}

\item{condition}{Condition to be examined (tumor vs normal etc); must exist
in covariates column.}

\item{adjustCovars}{Adjustment covariates like batch; if NULL,
no adjustments performed.}

\item{covariateCorrection}{If TRUE, performs covariates detection and
correction; requires **adjustCovars**; (limma).}

\item{quantileNorm}{If TRUE, performs quantile normalization on pathway
summary statistics; from *preprocess* package.}

\item{outDir}{Output directory.}

\item{saveOutName}{If not NULL, saves output as RDS using save name,
if NULL, does not save output.}

\item{id}{ID matching genes to pathways; rownames of geneCounts.}

\item{deGenes}{If not NULL, add t-scores to pathways summary statistics;
filter by genes t-scores.}

\item{minPathSize}{Minimum pathway size.}

\item{method}{Define method to use for pathway summary statistics;
specifications in documentations.}

\item{trim}{Filter pathways with mean less than trim threshold
in pathway summary statistics.}

\item{geneCountsLog}{If TRUE, log(geneCounts).}

\item{contrastConds}{Provide a contrast expression to be used in Limma
comparison. This is necessary if you have more than two levels in the
condition covariate.}
}
\value{
List containing differentially expressed pathways as DEP and pathway
  summary statistics as pathwaySummaryStats.
}
\description{
Performs differential expression analysis for pathways using LIMMA package
with gene counts
}
\examples{

data("path_gene_table")
data("miniTestsPanomiR")

differentialPathwayAnalysis(geneCounts = miniTestsPanomiR$mini_LIHC_Exp,
pathways =  path_gene_table,
covariates = miniTestsPanomiR$mini_LIHC_Cov,
condition = 'shortLetterCode')

}
