% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R, R/AllConstructor.R,
%   R/AllAccessors.R, R/AllGeneric.R
\docType{class}
\name{Rel-class}
\alias{Rel-class}
\alias{Rel}
\alias{Rel,data.frame-method}
\alias{Rel,character_OR_integer-method}
\alias{Rel,missing-method}
\alias{code}
\alias{code,Rel-method}
\alias{id1}
\alias{id1,Rel-method}
\alias{id2}
\alias{id2,Rel-method}
\alias{famid,Rel-method}
\alias{famid<-,Rel,character_OR_integer-method}
\alias{summary,Rel-method}
\alias{show,Rel-method}
\alias{as.list,Rel-method}
\alias{as.data.frame,Rel-method}
\alias{subset,Rel-method}
\title{Rel object}
\usage{
\S4method{Rel}{data.frame}(obj)

\S4method{Rel}{character_OR_integer}(obj, id2, code, famid = NA_character_, group = NA_character_)
}
\arguments{
\item{obj}{A character vector with the id of the first individuals
of each pairs or a \code{data.frame} with all the informations in
corresponding columns.}

\item{id2}{A character vector with the id of the second individuals
of each pairs}

\item{code}{A character, factor or numeric vector corresponding to
the relation code of the individuals:
\itemize{
\item MZ twin = Monozygotic twin
\item DZ twin = Dizygotic twin
\item UZ twin = twin of unknown zygosity
\item Spouse = Spouse
The following values are recognized:
\item character() or factor() : "MZ twin", "DZ twin", "UZ twin", "Spouse" with
of without space between the words. The case is not important.
\item numeric() : 1 = "MZ twin", 2 = "DZ twin", 3 = "UZ twin", 4 = "Spouse"
}}

\item{famid}{A character vector with the family identifiers of the
individuals. If provide, will be aggregated to the individuals
identifiers separated by an underscore.}

\item{group}{A numeric vector with the set number for twins.}
}
\value{
A Rel object.
}
\description{
S4 class to represent the special relationships in a Pedigree.

\subsection{Constructor :}{

You either need to provide a vector of the same size for each slot
or a \code{data.frame} with the corresponding columns.
}
}
\details{
A Rel object is a list of special relationships
between individuals in the pedigree.
It is used to create a Pedigree object.
The minimal needed informations are \code{id1}, \code{id2}
and \code{code}.

If a \code{famid} is provided, the individuals \code{id} will be aggregated
to the \code{famid} character to ensure the uniqueness of the \code{id}.
}
\section{Slots}{

\describe{
\item{\code{id1}}{A character vector with the id of the first individual.}

\item{\code{id2}}{A character vector with the id of the second individual.}

\item{\code{code}}{An ordered factor vector with the code of the special
relationship.

(i.e. \verb{MZ twin} < \verb{DZ twin} < \verb{UZ twin} < \code{Spouse}).}

\item{\code{famid}}{A character vector with the famid of the individuals.}

\item{\code{group}}{A numeric vector with the set number for twins.}
}}

\section{Accessors}{

For all the following accessors, the \code{x} parameters is a Rel object.
Each getters return a vector of the same length as \code{x} with the values
of the corresponding slot.


\itemize{
\item \code{code(x)} : Relationships' code
}


\itemize{
\item \code{id1(x)} : Relationships' first individuals' identifier
}


\itemize{
\item \code{id2(x)} : Relationships' second individuals' identifier
}


\itemize{
\item \code{famid(x)} : Relationships' individuals' family identifier
}


\itemize{
\item \code{famid(x) <- value} : Set the relationships' individuals' family
identifier
\itemize{
\item \code{value} : A character or integer vector of the same length as x
with the family identifiers
}
}
}

\section{Generics}{

\itemize{
\item \code{summary(x)}: Compute the summary of a Rel object
}


\itemize{
\item \code{show(x)}: Convert the Rel object to a data.frame
and print it with its summary.
}


\itemize{
\item \code{as.list(x)}: Convert a Rel object to a list
}


\itemize{
\item \code{as.data.frame(x)}: Convert a Rel object to a data.frame
}


\itemize{
\item \code{subset(x, i, keep = TRUE)}: Subset a Rel object
based on the individuals identifiers given.
\itemize{
\item \code{i} : A vector of individuals identifiers to keep.
\item \code{keep} : A logical value indicating if the individuals
should be kept or deleted.
}
}
}

\examples{

rel_df <- data.frame(
    id1 = c("1", "2", "3"),
    id2 = c("2", "3", "4"),
    code = c(1, 1, 4)
)
Rel(rel_df)

Rel(
    obj = c("1", "2", "3"),
    id2 = c("2", "3", "4"),
    code = c(1, 1, 4)
)
}
\seealso{
\code{\link[=Pedigree]{Pedigree()}}
}
