% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align.R
\docType{methods}
\name{align}
\alias{align}
\alias{align,Pedigree-method}
\title{Align a Pedigree object}
\usage{
\S4method{align}{Pedigree}(
  obj,
  packed = TRUE,
  width = 10,
  align = TRUE,
  hints = NULL,
  missid = "NA_character_",
  align_parents = TRUE,
  force = FALSE,
  precision = 4
)
}
\arguments{
\item{obj}{A Pedigree object}

\item{packed}{Should the Pedigree be compressed.
(i.e. allow diagonal lines connecting parents to children in order
to have a smaller overall width for the plot.)}

\item{width}{For a packed output, the minimum width of the plot, in
inches.}

\item{align}{For a packed Pedigree, align children under parents \code{TRUE},
to the extent possible given the page width, or align to to the left
margin \code{FALSE}.
This argument can be a two element vector, giving the alignment
parameters, or a logical value.
If \code{TRUE}, the default is \code{c(1.5, 2)}, or if numeric the routine
\code{alignped4()} will be called.}

\item{hints}{A Hints object or a named list containing
\code{horder} and \code{spouse}.
If \code{NULL} then the Hints stored in \strong{obj} will be used.}

\item{missid}{A character vector with the missing values identifiers.
All the id, dadid and momid corresponding to those values will be set
to \code{NA_character_}.}

\item{align_parents}{If \code{align_parents = TRUE}, go one step further
and try to make both parents of each child have the same depth.
(This is not always possible).
It helps the drawing program by lining up pedigrees that
'join in the middle' via a marriage.}

\item{force}{If \code{force = TRUE}, the function will return the depth minus
\code{min(depth)} if \code{depth} reach a state with no founders
is not possible.}

\item{precision}{The number of significatif numbers to round the
solution to.}
}
\value{
A list with components
\itemize{
\item \code{n}: A vector giving the number of subjects on each
horizonal level of the plot
\item \code{nid}: A matrix with one row for each level, giving
the numeric id of each subject plotted.
(A value of \code{17} means the 17th subject in the Pedigree).
\item \code{pos}: A matrix giving the horizontal position of each plot point
\item \code{fam}: A matrix giving the family id of each plot point.
A value of \code{3} would mean that the two subjects in positions
3 and 4, in the row above, are this subject's parents.
\item \code{spouse}: A matrix with values
\itemize{
\item \code{0} = not a spouse
\item \code{1} = subject plotted to the immediate right is a spouse
\item \code{2} = subject plotted to the immediate right is an inbred spouse
}
\item \code{twins}: Optional matrix which will only be present if the Pedigree
contains twins :
\itemize{
\item \code{0} = not a twin
\item \code{1} = sibling to the right is a monozygotic twin
\item \code{2} = sibling to the right is a dizygotic twin
\item \code{3} = sibling to the right is a twin of unknown zygosity
}
}
}
\description{
Given a Pedigree, this function creates helper matrices that describe the
layout of a plot of the Pedigree.
}
\details{
This is an internal routine, used almost exclusively by
\code{\link[=ped_to_plotdf]{ped_to_plotdf()}}.

The subservient functions \code{\link[=auto_hint]{auto_hint()}},
\code{\link[=alignped1]{alignped1()}}, \code{\link[=alignped2]{alignped2()}},
\code{\link[=alignped3]{alignped3()}}, and \code{\link[=alignped4]{alignped4()}}
contain the bulk of the computation.

If the \strong{hints} are missing the
\code{\link[=auto_hint]{auto_hint()}} routine is called to
supply an initial guess.

If multiple families are present in the \strong{obj} Pedigree, this routine
is called once for each family, and the results are combined in the
list returned.

For more information you can read the associated vignette:
\code{vignette("pedigree_alignment")}.
}
\examples{
data(sampleped)
pedi <- Pedigree(sampleped)
align(pedi)

}
\seealso{
\code{\link[=alignped1]{alignped1()}},
\code{\link[=alignped2]{alignped2()}},
\code{\link[=alignped3]{alignped3()}},
\code{\link[=alignped4]{alignped4()}},
\code{\link[=auto_hint]{auto_hint()}}
}
