% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_columns}
\alias{check_columns}
\title{Check columns presence in a dataframe}
\usage{
check_columns(
  df,
  cols_needed = NULL,
  cols_used = NULL,
  cols_to_use = NULL,
  others_cols = FALSE,
  cols_used_init = FALSE,
  cols_to_use_init = FALSE,
  cols_used_del = FALSE,
  verbose = FALSE,
  init_with = NA_character_
)
}
\arguments{
\item{df}{The dataframe to use}

\item{cols_needed}{A vector of columns needed}

\item{cols_used}{A vector of columns that are used by the script and
that will be overwritten.}

\item{cols_to_use}{A vector of optional columns that are authorized.}

\item{others_cols}{Boolean defining if non defined columns should be allowed.}

\item{cols_used_init}{Boolean defining if the columns that will be used
should be initialised to NA.}

\item{cols_to_use_init}{Boolean defining if the optional columns should be
initialised to NA.}

\item{cols_used_del}{Boolean defining if the columns that will be used
should be deleted.}

\item{verbose}{Should message be prompted to the user}
}
\value{
Dataframe with only the column allowed and all the column correctly
initialised.
}
\description{
Check for presence / absence of columns names
depending on their need
}
\details{
3 types of columns are here checked:
\itemize{
\item \code{cols_needed} : those columns need to be present if any is missing
an error will be prompted and the script will stop
\item \code{cols_used} : those columns will be used in the script and will be
overwritten to NA.
\item \code{cols_to_use} : those columns are optional and will be recognise
if present.
The last two types of columns can be initialised to NA if needed.
}
}
\examples{
data.frame
df <- data.frame(
    ColN1 = c(1, 2), ColN2 = 4,
    ColU1 = 'B', ColU2 = '1',
    ColTU1 = 'A', ColTU2 = 3,
    ColNR1 = 4, ColNR2 = 5
)
tryCatch(
    Pedixplorer:::check_columns(
        df,
        c('ColN1', 'ColN2'), c('ColU1', 'ColU2'),
        c('ColTU1', 'ColTU2')
), error = function(e) print(e))

}
\keyword{internal}
