% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SelfContPepSetTestWorkflow.R
\name{SelfContPepSetTestWorkflow}
\alias{SelfContPepSetTestWorkflow}
\title{Self-contained Peptide Set Test Workflow}
\usage{
SelfContPepSetTestWorkflow(
  dat,
  contrasts.par,
  group,
  pep_mapping_tbl,
  covar = NULL,
  logged = FALSE
)
}
\arguments{
\item{dat}{a dataframe or matrix of peptide abundance (row names should be peptide sequences or peptide IDs),
or a SummarizedExperiment object where grouping and peptide-protein mapping are
provided in colData and rowData, respectively.}

\item{contrasts.par}{group levels to be compared separated by dash (e.g., "B-A"
if group B is to be compared against group A)}

\item{group}{a vector of group levels corresponding to each sample. Alternatively, it can be the
column name of the group in colData if dat is a SummarizedExperiment object.}

\item{pep_mapping_tbl}{a table mapping peptides to proteins (it should include two columns named
"peptide" and "protein"). Alternatively, it can be the column name of the protein in rowData
if dat is a SummarizedExperiment object.}

\item{covar}{covariate matrix. Alternatively, it can be the column names of the covariates
in colData if dat is a SummarizedExperiment object.}

\item{logged}{Boolean variable indicating whether abundance data have been
log-transformed}
}
\value{
\code{SelfContPepSetTestWorkflow} returns a dataframe containing the following columns
\item{protein}{unique protein identifier}
\item{NPeps}{number of peptides}
\item{Direction}{direction of change}
\item{PValue}{raw p-value}
\item{adj.P.Val}{adjusted p-value}
\item{logFC}{average log2 fold change of peptides}
\item{Up}{number of upregulated peptides}
\item{Down}{number of downregulated peptides}
}
\description{
Given peptide abundance and assignment of peptide sequences to proteins,
execute the self-contained peptide set test workflow to compute the log2 fold change,
p-value, and adjusted p-value of all proteins identified.
}
\examples{
# Generate random peptide data
dat <- 2^matrix(rnorm(3000), ncol = 6)
colnames(dat) <- paste0("Sample", 1:6)
rownames(dat) <- paste0("Peptide", 1:500)

# Generate peptide mapping table
pep_mapping_tbl <- data.frame(peptide = paste0("Peptide", 1:500),
protein = paste0("Protein", rep(1:100, each = 5)))

# Generate groups and contrasts
group <- c(rep("A", 3), rep("B", 3))
contrasts.par <- "B-A"

SelfContPepSetTestWorkflow(dat, contrasts.par = contrasts.par,
group = group,
pep_mapping_tbl = pep_mapping_tbl,
logged = FALSE)

# Store data as a SummarizedExperiment object; add covariates
library(tibble)
library(SummarizedExperiment)
colData <- data.frame(sample = LETTERS[seq_along(group)], group = group, 
sex = c("M", "F", "M", "F", "F", "M"), age = 1:6) |>
column_to_rownames(var = "sample")
rowData <- pep_mapping_tbl |> column_to_rownames(var = "peptide")
dat.nn <- dat
rownames(dat.nn) <- NULL
colnames(dat.nn) <- NULL
dat.se <- SummarizedExperiment(assays = list(int = dat.nn), colData = colData, rowData = rowData)

SelfContPepSetTestWorkflow(dat.se, contrasts.par = contrasts.par,
group = "group",
pep_mapping_tbl = "protein",
covar = c("sex", "age"),
logged = FALSE)

}
\references{
Wu, D, Lim, E, Francois Vaillant, F, Asselin-Labat, M-L, Visvader, JE, and Smyth, GK (2010). ROAST: rotation gene set tests for complex microarray experiments. \emph{Bioinformatics} 26, 2176-2182
}
\author{
Junmin Wang
}
