% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/library.R
\name{peptideLibraries}
\alias{peptideLibraries}
\alias{getLibrary}
\alias{makeLibrary}
\alias{removeLibrary}
\alias{listLibrary}
\title{Peptide libraries}
\usage{
getLibrary(name)

makeLibrary(library, name)

removeLibrary(name)

listLibrary()
}
\arguments{
\item{name}{name of the library}

\item{library}{a \code{matrix}, \code{data.frame}, or
\linkS4class{DataFrame} with the peptide information for the
specified library.}
}
\value{
\code{getLibrary} returns a \linkS4class{DataFrame} corresponding to
the peptide information for the specified library.
}
\description{
PhIP-Seq experiments often use identical peptide libraries
different cohorts. These functions enable the user to conveniently reuse
tidied libraries.
}
\details{
Each library is stored as a \linkS4class{DataFrame} in .rds file.
New libraries can be stored for future use with the \code{makeLibrary}
function.
}
\section{Functions}{
\itemize{
\item \code{getLibrary}: return a \linkS4class{DataFrame} with the
peptide information corresponding to the library.

\item \code{makeLibrary}: create and store a \linkS4class{DataFrame} with
the specified peptide information.

\item \code{removeLibrary}: delete stored libraries

\item \code{listLibrary}: list all available libraries
}}

\examples{
## Create a new library
pep_meta <- data.frame(species = c(
    rep("human immunodeficiency virus", 3),
    rep("Epstein-Barr virus", 2)
))
makeLibrary(pep_meta, "new_library")

## Use new library
counts_dat <- matrix(1:10, nrow = 5)
phip_obj <- PhIPData(
    counts = counts_dat,
    peptideInfo = getLibrary("new_library")
)

## List libraries
listLibrary()

## Delete created library
removeLibrary("new_library")

}
