% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLogisticRegression.R
\name{logLogisticRegression}
\alias{logLogisticRegression}
\title{Fits curves of the form E = E_inf + (1 - E_inf)/(1 + (c/EC50)^HS) to dose-response data points (c, E) given by the user
and returns a vector containing estimates for HS, E_inf, and EC50.}
\usage{
logLogisticRegression(
  conc,
  viability,
  density = c(2, 10, 5),
  step = 0.5/density,
  precision = 1e-04,
  lower_bounds = c(0, 0, -6),
  upper_bounds = c(4, 1, 6),
  scale = 0.07,
  family = c("normal", "Cauchy"),
  median_n = 1,
  conc_as_log = FALSE,
  viability_as_pct = TRUE,
  trunc = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{conc}{\code{numeric} is a vector of drug concentrations.}

\item{viability}{\code{numeric} is a vector whose entries are the viability values observed in the presence of the
drug concentrations whose logarithms are in the corresponding entries of the log_conc, where viability 0
indicates that all cells died, and viability 1 indicates that the drug had no effect on the cells.}

\item{density}{\code{numeric} is a vector of length 3 whose components are the numbers of lattice points per unit
length along the HS-, E_inf-, and base-10 logarithm of the EC50-dimensions of the parameter space, respectively.}

\item{step}{\code{numeric} is a vector of length 3 whose entries are the initial step sizes in the HS, E_inf, and
base-10 logarithm of the EC50 dimensions, respectively, for the PatternSearch algorithm.}

\item{precision}{is a positive real number such that when the ratio of current step size to initial step
size falls below it, the PatternSearch algorithm terminates. A smaller value will cause LogisticPatternSearch
to take longer to complete optimization, but will produce a more accurate estimate for the fitted parameters.}

\item{lower_bounds}{\code{numeric} is a vector of length 3 whose entries are the lower bounds on the HS, E_inf,
and base-10 logarithm of the EC50 parameters, respectively.}

\item{upper_bounds}{\code{numeric} is a vector of length 3 whose entries are the upper bounds on the HS, E_inf,
and base-10 logarithm of the EC50 parameters, respectively.}

\item{scale}{is a positive real number specifying the shape parameter of the Cauchy distribution.}

\item{family}{\code{character}, if "cauchy", uses MLE under an assumption of Cauchy-distributed errors
instead of sum-of-squared-residuals as the objective function for assessing goodness-of-fit of
dose-response curves to the data. Otherwise, if "normal", uses MLE with a gaussian assumption of errors}

\item{median_n}{If the viability points being fit were medians of measurements, they are expected to follow a median of \code{family}
distribution, which is in general quite different from the case of one measurement. Median_n is the number of measurements
the median was taken of. If the measurements are means of values, then both the Normal and the Cauchy distributions are stable, so means of
Cauchy or Normal distributed variables are still Cauchy and normal respectively.}

\item{conc_as_log}{\code{logical}, if true, assumes that log10-concentration data has been given rather than concentration data,
and that log10(EC50) should be returned instead of EC50.}

\item{viability_as_pct}{\code{logical}, if false, assumes that viability is given as a decimal rather
than a percentage, and that E_inf should be returned as a decimal rather than a percentage.}

\item{trunc}{\code{logical}, if true, causes viability data to be truncated to lie between 0 and 1 before
curve-fitting is performed.}

\item{verbose}{\code{logical}, if true, causes warnings thrown by the function to be printed.}
}
\value{
A list containing estimates for HS, E_inf, and EC50. It is annotated with the attribute Rsquared, which is the R^2 of the fit.
Note that this is calculated using the values actually used for the fit, after truncation and any transform applied. With truncation, this will be
different from the R^2 compared to the variance of the raw data. This also means that if all points were truncated down or up, there is no variance
in the data, and the R^2 may be NaN.
}
\description{
By default, logLogisticRegression uses an L-BFGS algorithm to generate the fit. However, if
this fails to converge to solution, logLogisticRegression samples lattice points throughout the parameter space.
It then uses the lattice point with minimal least-squares residual as an initial guess for the optimal parameters,
passes this guess to drm, and re-attempts the optimization. If this still fails, logLogisticRegression uses the
PatternSearch algorithm to fit a log-logistic curve to the data.
}
\examples{
dose <- c(0.0025,0.008,0.025,0.08,0.25,0.8,2.53,8)
viability <- c(108.67,111,102.16,100.27,90,87,74,57)
computeAUC(dose, viability)

}
