% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinaseSubstratePrediction.R
\name{kinaseSubstrateHeatmap}
\alias{kinaseSubstrateHeatmap}
\title{Kinase-substrate annotation prioritisation heatmap}
\usage{
kinaseSubstrateHeatmap(
  phosScoringMatrices,
  top = 3,
  printPlot = NULL,
  filePath = "./kinaseSubstrateHeatmap.pdf",
  width = 10,
  height = 10
)
}
\arguments{
\item{phosScoringMatrices}{a matrix returned from kinaseSubstrateScore.}

\item{top}{the number of top ranked phosphosites for each kinase to be
included in the heatmap. Default is 1.}

\item{printPlot}{indicate whether the plot should be saved as a PDF
in the specified directory. Default is NULL, otherwise specify TRUE.}

\item{filePath}{path name to save the plot as a PDF file. 
Default saves in the working directory.}

\item{width}{width of PDF.}

\item{height}{height of PDF.}
}
\value{
a pheatmap object.
}
\description{
Kinase-substrate annotation prioritisation heatmap
}
\examples{
\donttest{
data('phospho_L6_ratio_pe')
data('SPSs')
data('PhosphoSitePlus')

ppe <- phospho.L6.ratio.pe
sites = paste(sapply(GeneSymbol(ppe), function(x)x),";",
    sapply(Residue(ppe), function(x)x),
    sapply(Site(ppe), function(x)x),
    ";", sep = "")
grps = gsub("_.+", "", colnames(ppe))
design = model.matrix(~ grps - 1)
ctl = which(sites \%in\% SPSs)
ppe = RUVphospho(ppe, M = design, k = 3, ctl = ctl)

phosphoL6 = SummarizedExperiment::assay(ppe, "normalised")

# filter for up-regulated phosphosites
phosphoL6.mean <- meanAbundance(phosphoL6, grps = grps)
aov <- matANOVA(mat=phosphoL6, grps = grps)
idx <- (aov < 0.05) & (rowSums(phosphoL6.mean > 0.5) > 0)
phosphoL6.reg <- phosphoL6[idx, ,drop = FALSE]

L6.phos.std <- standardise(phosphoL6.reg)

rownames(L6.phos.std) <- paste0(GeneSymbol(ppe), ";", Residue(ppe), 
    Site(ppe), ";")[idx]

L6.phos.seq <- Sequence(ppe)[idx]

L6.matrices <- kinaseSubstrateScore(PhosphoSite.mouse, L6.phos.std,
    L6.phos.seq, numMotif = 5, numSub = 1)
    
kinaseSubstrateHeatmap(L6.matrices)
kinaseSubstrateHeatmap(L6.matrices, printPlot=TRUE)
}
}
