% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolBox.R
\name{matANOVA}
\alias{matANOVA}
\title{ANOVA test}
\usage{
matANOVA(mat, grps)
}
\arguments{
\item{mat}{An p by n matrix where p is the number of phosphosites and n is
the number of samples}

\item{grps}{A vector of length n, with group or time point information of the
samples}
}
\value{
A vector of multiple testing adjusted p-values
}
\description{
Performs an ANOVA test and returns its adjusted p-value
}
\examples{
data('phospho_L6_ratio_pe')
data('SPSs')
data('PhosphoSitePlus')

grps = gsub('_.+', '', colnames(phospho.L6.ratio.pe))

# Construct a design matrix by condition
design = model.matrix(~ grps - 1)

# phosphoproteomics data normalisation using RUV
L6.sites = paste(sapply(GeneSymbol(phospho.L6.ratio.pe), function(x)paste(x)),
                 ";",
                 sapply(Residue(phospho.L6.ratio.pe), function(x)paste(x)),
                 sapply(Site(phospho.L6.ratio.pe), function(x)paste(x)),
                 ";", sep = "")
ctl = which(L6.sites \%in\% SPSs)
phospho.L6.ratio.pe = RUVphospho(phospho.L6.ratio.pe,
                                 M = design, k = 3,ctl = ctl)
phosphoL6 = SummarizedExperiment::assay(phospho.L6.ratio.pe, "normalised")

# filter for up-regulated phosphosites
phosphoL6.mean <- meanAbundance(phosphoL6, grps = grps)
aov <- matANOVA(mat=phosphoL6, grps = grps)
}
