% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolBox.R
\name{meanAbundance}
\alias{meanAbundance}
\title{Obtain average expression from replicates}
\usage{
meanAbundance(mat, grps)
}
\arguments{
\item{mat}{a matrix with rows correspond to phosphosites and columns
correspond to samples.}

\item{grps}{a string specifying the grouping (replciates).}
}
\value{
a matrix with mean expression from replicates
}
\description{
Obtain average expression from replicates
}
\examples{
data('phospho_L6_ratio_pe')
data('SPSs')
data('PhosphoSitePlus')

grps = gsub('_.+', '', colnames(phospho.L6.ratio.pe))

# Construct a design matrix by condition
design = model.matrix(~ grps - 1)

# phosphoproteomics data normalisation using RUV
L6.sites = paste(sapply(GeneSymbol(phospho.L6.ratio.pe), function(x)paste(x)),
                 ";",
                 sapply(Residue(phospho.L6.ratio.pe), function(x)paste(x)),
                 sapply(Site(phospho.L6.ratio.pe), function(x)paste(x)),
                 ";", sep = "")
ctl = which(L6.sites \%in\% SPSs)
phospho.L6.ratio.pe = RUVphospho(phospho.L6.ratio.pe,
                                 M = design, k = 3,ctl = ctl)

phosphoL6 = SummarizedExperiment::assay(phospho.L6.ratio.pe, "normalised")
phosphoL6.mean <- meanAbundance(phosphoL6, grps = grps)

}
