% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Impute.R
\name{ptImpute}
\alias{ptImpute}
\title{Paired-tail (pt) based impute}
\usage{
ptImpute(
    mat1, 
    mat2, 
    percent1, 
    percent2, 
    m = 1.6, 
    s = 0.6, 
    paired = TRUE, 
    verbose = TRUE,
    assay
)
}
\arguments{
\item{mat1}{a matrix (or PhosphoExperiment object) with rows correspond to
phosphosites and columns correspond to replicates within treatment1.}

\item{mat2}{a matrix (or PhosphoExperiment object) with rows correspond to
phosphosites and columns correspond to replicates within treatment2.}

\item{percent1}{a percent indicating minimum quantified percentages required
for considering for imputation.}

\item{percent2}{a percent indicating minimum quantified percentages required
for considering for imputation.}

\item{m}{a numeric number of for controlling mean downshifting.}

\item{s}{a numeric number of for controlling standard deviation of
downshifted sampling values.}

\item{paired}{a flag indicating whether to impute for both treatment1 and
treatment2 (default) or treatment2 only (if paired=FALSE).}

\item{verbose}{Default to \code{TRUE} to show messages during the progress.
All messages will be suppressed if set to \code{FALSE}}

\item{assay}{an assay to be selected if \code{mat} is a PhosphoExperiment 
object.}
}
\value{
An imputed matrix
}
\description{
Impute the missing values for mat2 using tail imputation approach if mat1 has
more than percent1 (percentage) of quantified values
and mat2 has less than percent2 (percentage) quantified values,
and vice versa if paired is set to be true. That is if mat2 has percentage of
quantified values more than percent1 and mat1 has percentage quantified
values less than percent2.
}
\examples{

data('phospho.cells.Ins.sample')
grps = gsub('_[0-9]{1}', '', colnames(phospho.cells.Ins))
phospho.cells.Ins.filtered <- selectGrps(phospho.cells.Ins, grps, 0.5, n=1)

set.seed(123)
phospho.cells.Ins.impute <-
    scImpute(
    phospho.cells.Ins.filtered,
    0.5,
    grps)[,colnames(phospho.cells.Ins.filtered)]

set.seed(123)
phospho.cells.Ins.impute[,seq(6)] <- 
    ptImpute(phospho.cells.Ins.impute[,seq(7,12)],
phospho.cells.Ins.impute[,seq(6)], percent1 = 0.6, percent2 = 0, 
    paired = FALSE)


# For PhosphoExperiment objects
# mat = PhosphoExperiment(
#     assay = phospho.cells.Ins.impute,
#     colData = S4Vectors::DataFrame(
#         groups = grps
#     )
# )
# SummarizedExperiment::assay(mat)[,seq(6)] <- 
#     ptImpute(SummarizedExperiment::assay(mat)[,seq(7,12)],
#         SummarizedExperiment::assay(mat)[,seq(6)], percent1 = 0.6, 
#         percent2 = 0, paired = FALSE)

}
