% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pirat_utils.R
\name{impute_block_llk_reset_PG}
\alias{impute_block_llk_reset_PG}
\title{Impute each PG.}
\usage{
impute_block_llk_reset_PG(
  data.pep.rna.crop,
  psi,
  psi_rna,
  rna.cond.mask,
  pep.cond.mask,
  pep_ab_or = NULL,
  df = 2,
  nu_factor = 1,
  max_pg_size = NULL,
  max.pg.size2imp = 1,
  verbose = FALSE,
  version = "accelerated",
  ...
)
}
\arguments{
\item{data.pep.rna.crop}{A list representing dataset, with mRNA normalized 
counts and mRNA/PGs adjacecy table.}

\item{psi}{Inverse scale parameter for IW prior of peptides abundances}

\item{psi_rna}{Inverse scale parameter for IW prior of mRNA abundances}

\item{rna.cond.mask}{Vector of size equal to the number of samples in mRNA 
abundance table, 
containing indices of conditions of each sample.}

\item{pep.cond.mask}{Vector of size equal to the number of samples in 
peptide abundance table, 
containing indices of conditions of each sample.}

\item{pep_ab_or}{In case we impute a dataset with pseudo-MVS, we can provide 
the ground truth abundance table, such that imputation will by done only for 
pseudo-MVs. This will accelerate imputation algorithm.}

\item{df}{Estimate degree of freedom of the IG distribution fitted on 
observed variance.}

\item{nu_factor}{Multiplication factor on degree of freedom. 2 by default.}

\item{max_pg_size}{Maximum PGs size authorized for imputation. PG size is 
plitted if its size is above this threshold.}

\item{max.pg.size2imp}{Maximum PG size to impute after splitting. PGs for 
which size is greater are not imputed. Should be lower than max_pg_size to 
have effect.}

\item{verbose}{A boolean (FALSE as default) which indicates whether to 
display more details ont the process}

\item{version}{Version to use, either "original_BSTS_2025" for the original 
version or "accelerated" (default) a faster modified version.}

\item{...}{Additional parameters}
}
\value{
A list containing imputation results for each PG, the execution 
time, and adjacency matrix between peptides and PGs corresponding to the 
 imputed PGs.
}
\description{
Imputes each PG separately accounting for transcriptomic 
dataset and returns the results for each PG.
}
\examples{
\donttest{
Py_impute_block_llk_reset_PG <- function(data.pep.rna.crop, ...) { 
proc <- basilisk::basiliskStart(envPirat)

func <- basilisk::basiliskRun(proc, 
    fun = function(arg1, ...) {
        Pirat::impute_block_llk_reset_PG(arg1, ...)
    }, arg1 = data.pep.rna.crop, ...)
basilisk::basiliskStop(proc)
func
}

data(subropers)
obj <- subropers
# Keep only fully observed peptides
obs2NApep <- obj$peptides_ab[ ,colSums(is.na(obj$peptides_ab)) <= 0] 
res_hyperparam_pep = estimate_psi_df(obs2NApep)
psi_pep <- res_hyperparam_pep$psi
obs2NArna <- obj$rnas_ab[ ,colSums(obj$rnas_ab == 0) <= 0]
res_hyperparam_rna = estimate_psi_df(obs2NArna)
psi_rna <- res_hyperparam_rna$psi
# paired proteomic transcriptomic setting
cond_mask <- seq(nrow(obj$peptides_ab)) 
imputed_pgs <- Py_impute_block_llk_reset_PG(
    data.pep.rna.crop = obj, 
    psi = psi_pep, 
    psi_rna = psi_rna, 
    rna.cond.mask = cond_mask, 
    pep.cond.mask = cond_mask)
    }


}
