% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pirat_utils.R
\name{rm_pg_from_idx_merge_pg}
\alias{rm_pg_from_idx_merge_pg}
\title{Remove PGs by index and merge}
\usage{
rm_pg_from_idx_merge_pg(l_pep_rna, pg_idx)
}
\arguments{
\item{l_pep_rna}{A list representing dataset, formatted as in 
pipeline_llkimpute function}

\item{pg_idx}{Vector of indices}
}
\value{
A list representing dataset.
}
\description{
Remove PG by index and merge transcripts (if transcriptomic 
information is available) of PG included in one another (under condition 
that they have peptide). Then it removes transcripts without PG. Do not 
remove peptides that are left without PG.
}
\examples{
data(ropers)
idxs_emb_prot = get_indexes_embedded_prots(ropers$adj)
ropers_wo_emb_prot = rm_pg_from_idx_merge_pg(ropers, idxs_emb_prot)

}
