% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatTestPaired.R
\name{permtest_paired}
\alias{permtest_paired}
\title{Perform permutation tests}
\usage{
permtest_paired(tMAData)
}
\arguments{
\item{tMAData}{A matrix of data for running permutation tests}
}
\value{
A list containing the p-values and q-values (Benjamini-Hochberg)
}
\description{
This function performs permutation tests on the given tMAData
The permutation tests determine an empirical null distribution of t-values
for the p-value calculation
}
\examples{
tMAData <- matrix(rnorm(100), nrow = 10)
tout <- permtest_paired(tMAData)
head(tout$qPermutvalues)
}
\keyword{analysis}
\keyword{paired}
\keyword{permutation}
