% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{HMM_merge}
\alias{HMM_merge}
\title{Internal Function 10}
\usage{
HMM_merge(
  data,
  cluster_num,
  base_clust,
  eps = 10^(-10),
  max_iter = 1000,
  lambdas = rep(2, 2),
  coefs = rep(1, 2)
)
}
\arguments{
\item{data}{A matrix or data frame of fluorescence intensities in each channel. Each row represents each partitions, and each column each channel.}

\item{cluster_num}{The expected maximum number of clusters}

\item{base_clust}{base clustering results before merging}

\item{eps}{the convergence threshold}

\item{max_iter}{maximum number of iterations}

\item{lambdas}{The penalty terms for the deviation from the expected cluster centers. Higher \code{lambdas} penalizes the deviation more.}

\item{coefs}{The coefficients to adjust for the expected cluster centers. The default is 1 which can be used for common assay designs and has
to be modified for special assays such as competing assays.}
}
\value{
A list of membership probability, cluster center, merging probability
}
\description{
This function merges the excess clusters given by the base clustering
}
\keyword{internal}
