% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoPart_MultiMS.R
\name{convert_log2}
\alias{convert_log2}
\title{Convert values in a matrix to log2 transfored values}
\usage{
convert_log2(mm, use_cols)
}
\arguments{
\item{mm}{a dataframe of raw intensities in format:
(# peptides)x(# samples+possibly peptide & protein information (metadata))}

\item{use_cols}{vector of column indecies that make up the intensities
usually in sequential order but do not have to be
user is responsible for making sure that specified columns are
indeed numeric and correspond to intensities for each sample}
}
\value{
matrix of log2 transforemd intensities where 0's were
        replaced with NA's prior
        to transformation
}
\description{
convert_log2 replaces 0's with NA's than does a log2 transformation
Replacing 0's with NA's is the correct approach to Proteomics data analysis
as 0's are not values that should be left in the data where no
observation was made, see citation below.
Karpievitch et al. 2009 "Normalization of peak intensities in
  bottom-up MS-based proteomics using singular value decomposition".
  PMID: 19602524
Karpievitch et al. 2009 "A statistical framework for protein
  quantitation in bottom-up MS-based proteomics".  PMID: 19535538
}
\examples{
data(mm_peptides)
head(mm_peptides)
intsCols = 8:13
metaCols = 1:7
m_logInts = make_intencities(mm_peptides, intsCols)
m_prot.info = make_meta(mm_peptides, metaCols)
m_logInts = convert_log2(m_logInts) # 0's replaced with NAs and
                                    # log2 transnform applied

}
