% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBImpute.R
\name{eigen_pi}
\alias{eigen_pi}
\title{Compute PI - proportion of observations missing completely at random}
\usage{
eigen_pi(m, toplot = TRUE)
}
\arguments{
\item{m}{matrix of abundances, numsmaples x numpeptides}

\item{toplot}{TRUE/FALSE plot mean vs protportion missing curve and PI}
}
\value{
pi estimate of the proportion of
        observations missing completely at random

Contributed by Shelley Herbrich & Tom Taverner for Karpievitch et al. 2009
}
\description{
Compute PI - proportion of observations missing completely at random
}
\examples{
data(mm_peptides)
intsCols = 8:13
metaCols = 1:7
m_logInts = make_intencities(mm_peptides, intsCols)
m_prot.info = make_meta(mm_peptides, metaCols)
m_logInts = convert_log2(m_logInts)
my.pi = eigen_pi(m_logInts, toplot=TRUE)
}
