% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peptideLevel_DE.R
\name{peptideLevel_DE}
\alias{peptideLevel_DE}
\title{Model-Based differential expression analysis}
\usage{
peptideLevel_DE(mm, treatment, prot.info, pr_ppos = 2)
}
\arguments{
\item{mm}{m x n matrix of intensities, num peptides x num samples}

\item{treatment}{vector indicating the treatment group
of each sample ie [1 1 1 1 2 2 2 2...]}

\item{prot.info}{2+ colum data frame of peptide ID, protein ID, etc. columns}

\item{pr_ppos}{- column index for protein ID in prot.info.
Can restrict to be #2...}
}
\value{
A data frame with the following columns:
\describe{
  \item{ProtID}{protein identification information taken from prot.info,
                1 column used to identify proteins}
  \item{FC}{fold change}
  \item{p-value}{p-value for the comparison between 2 groups
                (2 groups only here)}
  \item{BH-adjusted p-value}{Benjamini-Hochberg adjusted p-values}
}
}
\description{
Model-Based differential expression analysis is performed on peptide
level as desribed in
Karpievitch et al. 2009 "A statistical framework for protein quantitation in
bottom-up MS-based proteomics" Bioinformatics.
}
\examples{
data(mm_peptides)
head(mm_peptides)
# different from parameter names as R uses outer
# name spaces if variable is undefined
intsCols = 8:13
metaCols = 1:7 # reusing this variable
m_logInts = make_intencities(mm_peptides, intsCols)
m_prot.info = make_meta(mm_peptides, metaCols)
m_logInts = convert_log2(m_logInts)
grps = as.factor(c('CG','CG','CG', 'mCG','mCG','mCG'))

set.seed(135) # results rarely vary due to the random seed for EigenMS
mm_m_ints_eig1 = eig_norm1(m=m_logInts,treatment=grps,prot.info=m_prot.info)
mm_m_ints_eig1$h.c # check the number of bias trends detected
mm_m_ints_norm = eig_norm2(rv=mm_m_ints_eig1)
mm_prot.info = mm_m_ints_norm$normalized[,1:7]
mm_norm_m =  mm_m_ints_norm$normalized[,8:13]

set.seed(131) # important to reproduce the results later
imp_mm = MBimpute(mm_norm_m, grps, prot.info=mm_prot.info,
                  pr_ppos=2, my.pi=0.05,
                  compute_pi=FALSE)
DE_res = peptideLevel_DE(imp_mm$y_imputed,
                         grps, mm_m_ints_norm$normalized[,metaCols],
                         pr_ppos=2)
}
