% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AssayLinks.R
\name{AssayLinks}
\alias{AssayLinks}
\alias{AssayLink}
\alias{AssayLink-class}
\alias{AssayLinks-class}
\alias{class:AssayLinks}
\alias{class:AssayLink}
\alias{show,AssayLink-method}
\alias{[,AssayLink,character-method}
\alias{[,AssayLinks,character-method}
\alias{updateObject,AssayLinks-method}
\alias{updateObject,AssayLink-method}
\alias{assayLink}
\alias{assayLinks}
\alias{[,AssayLink,character,ANY,ANY-method}
\alias{[,AssayLinks,list,ANY,ANY-method}
\alias{addAssayLink}
\alias{addAssayLinkOneToOne}
\title{Links between Assays}
\usage{
\S4method{show}{AssayLink}(object)

\S4method{updateObject}{AssayLinks}(object, ..., verbose = FALSE)

\S4method{updateObject}{AssayLink}(object, ..., verbose = FALSE)

AssayLink(name, from = NA_character_, fcol = NA_character_, hits = Hits())

AssayLinks(..., names = NULL)

assayLink(x, i)

assayLinks(x, i)

\S4method{[}{AssayLink,character,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{AssayLinks,list,ANY,ANY}(x, i, j, ..., drop = TRUE)

addAssayLink(object, from, to, varFrom, varTo)

addAssayLinkOneToOne(object, from, to)
}
\arguments{
\item{object}{An \code{AssayLink} object to show.}

\item{...}{A set of \code{AssayLink} objects or a list thereof.}

\item{verbose}{logical (default FALSE) whether to print extra messages}

\item{name}{A mandatory name of the assay(s).}

\item{from}{A \code{character()} or \code{integer()} indicating which
assay(s) to link from in \code{object}}

\item{fcol}{The feature variable of the parent assay used to
generate the current assay (used in
\code{aggregateFeatures}). \code{NA_character_}, if not applicable.}

\item{hits}{An object of class \link[S4Vectors:Hits-class]{S4Vectors::Hits} matching the
features of two assays.}

\item{names}{A \code{character()} of \code{AssayLink} names. If provided,
\code{...} are ignored, and \code{names} is used to create an
\code{AssayLinks} object with \code{AssayLink} instances with names
\code{names}.}

\item{x}{An instance of class \link{QFeatures}.}

\item{i}{The index or name of the assay whose \code{AssayLink} and
parents \code{AssayLink} instances are to be returned. For \code{[}, the
feature names to filter on.}

\item{j}{ignored.}

\item{drop}{ignored.}

\item{to}{A \code{character(1)} or \code{integer(1)} indicating which assay
to link to in \code{object}}

\item{varFrom}{A \code{character()} indicating the feature variable(s)
to use to match the \code{from} assay(s) to the \code{to}
assay. \code{varFrom} must have the same length as \code{from} and is
assumed to be ordered as \code{from}.}

\item{varTo}{A \code{character(1)} indicating the feature variable to
use to match the \code{to} assay to the \code{from} assay(s).}
}
\value{
\code{assayLink} returns an instance of class \code{AssayLink}.

\code{assayLinks} returns an instance of class \code{AssayLinks}.
}
\description{
Links between assays within a \link{QFeatures} object are handled by an
\code{AssayLinks} object. It is composed by a list of \code{AssayLink}
instances.
}
\section{Constructors}{


Object can be created with the \code{AssayLink()} and \code{AssayLinks()}
constructors.
}

\section{Methods and functions}{

\itemize{
\item \code{assayLink(x, i)} accesses the AssayLink at position \code{i} or with
name \code{i} in the \link{QFeatures} object \code{x}.
\item \code{parentAssayLinks(x, i, recursive = FALSE)} accesses the
parent(s) \code{AssayLinks} or assay with index or name \code{i}.
}
}

\section{Creating links between assays}{

\itemize{
\item \code{addAssayLink} takes a parent assay and a child assay contained
in the \link{QFeatures} object and creates a link given a matching
feature variable in each assay's \code{rowData}. \code{addAssayLink} also
allows to link an assay from multiple parent assays (see
examples below).
\item \code{addAssayLinkOneToOne} links two assays contained in the
\link{QFeatures} object. The parent assay and the child assay must
have the same size and contain the same rownames (a different
ordering is allowed). The matching is performed based on the row
names of the assays, instead of a supplied variable name in
\code{rowData}. Providing multiple parents is not supported.
}
}

\examples{

##-----------------------------
## Creating an AssayLink object
##-----------------------------

al1 <- AssayLink(name = "assay1")
al1

##------------------------------
## Creating an AssayLinks object
##------------------------------

AssayLinks(al1)

al2 <- AssayLinks(names = c("Assay1", "Assay2"))
al2

##---------------------------------------
## Adding an AssayLink between two assays
##---------------------------------------

## create a QFeatures object with 2 (identical) assays
## see also '?QFeatures'
se <- SummarizedExperiment(matrix(runif(20), ncol = 2,
                                  dimnames = list(LETTERS[1:10],
                                                  letters[1:2])),
                           rowData = DataFrame(ID = 1:10))
ft <- QFeatures(list(assay1 = se, assay2 = se))

## assay1 and assay2 are not linked
assayLink(ft, "assay2") ## 'from' is NA
assayLink(ft, "assay1") ## 'from' is NA

## Suppose assay2 was generated from assay1 and the feature variable
## 'ID' keeps track of the relationship between the two assays
ftLinked <- addAssayLink(ft, from = "assay1", to = "assay2",
                         varFrom = "ID", varTo = "ID")
assayLink(ftLinked, "assay2")

## For one-to-one relationships, you can also use
ftLinked <- addAssayLinkOneToOne(ft, from = "assay1", to = "assay2")
assayLink(ftLinked, "assay2")

##----------------------------------------
## Adding an AssayLink between more assays
##----------------------------------------

## An assay can also be linked to multiple parent assays
## Create a QFeatures object with 2 parent assays and 1 child assay
ft <- QFeatures(list(parent1 = se[1:6, ], parent2 = se[4:10, ], child = se))
ft <- addAssayLink(ft, from = c("parent1", "parent2"), to = "child",
                   varFrom = c("ID", "ID"), varTo = "ID")
assayLink(ft, "child")

}
