% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rzinbinom}
\alias{rzinbinom}
\title{Generate random samples from a zero-inflated negative binomial distribution}
\usage{
rzinbinom(n, mu, theta, size, pi)
}
\arguments{
\item{n}{Integer. Number of samples to generate.}

\item{mu}{Numeric. Mean of the negative binomial distribution.}

\item{theta}{Numeric. Dispersion parameter (size) of the negative binomial
distribution.}

\item{size}{Numeric. Alternative name for the dispersion parameter
(used interchangeably with \code{theta}).}

\item{pi}{Numeric. Zero-inflation probability; must be in the range
\eqn{[0,1]}.}
}
\value{
A vector of random samples from a Zero-Inflated Negative Binomial
(ZINB) distribution.
}
\description{
Generate random samples from a zero-inflated negative binomial distribution
}
\examples{
set.seed(1)
rzinbinom(n = 5, mu = 10, theta = 5, pi = 0.2)
}
