% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtle_row_ids.R
\docType{methods}
\name{qtle-row_ids}
\alias{qtle-row_ids}
\alias{feature_id}
\alias{feature_id<-}
\alias{feature_id,QTLExperiment-method}
\alias{feature_id<-,QTLExperiment-method}
\alias{variant_id}
\alias{variant_id<-}
\alias{variant_id,QTLExperiment-method}
\alias{variant_id<-,QTLExperiment-method}
\title{Named rowData getters and setters}
\arguments{
\item{object}{is a \linkS4class{QTLExperiment} object.}

\item{value}{is a vector with length equal to the number of rows of x.}
}
\value{
For \code{feature_id}, a vector is returned containing the name of the
feature tested in each association.
For \code{feature_id<-}, a modified \code{object} is returned with the
updated feature_ids in \code{\link{rowData}}, and
in the row.names of the \linkS4class{QTLExperiment} object.
For \code{variant_id}, a vector is returned containing the name of the
variant tested in each association.
For \code{variant_id<-}, a modified \code{object} is returned with the
updated variant_ids in \code{\link{rowData}}, and
in the row.names of the \linkS4class{QTLExperiment} object.
}
\description{
These are methods for getting or setting protected rowData columns (i.e.
feature_id and variant_id).
}
\details{
QTL are associations between a genetic variants and a quantitative feature.
The \code{\link{feature_id}} and \code{\link{variant_id}} methods can be used
to get or set feature IDs and variant IDs, respectively, across a
\linkS4class{QTLExperiment} object. The values are stored in the
\code{\link{rowData}} compartments and have additional protections 
to prevent them being removed or overwritten. 
The \code{\link{feature_id}} can store gene or metabolite names, while 
\code{\link{variant_id}} could be used to store variant information such
as SNP names.
}
\section{Available methods}{

Here \code{object} is a \linkS4class{QTLExperiment} object,
\code{value} is a vector-like object with compatible dimensions to \code{object}.

\describe{
\item{\code{feature_id(object)}:}{
Get the feature names.
}
\item{\code{feature_id(object) <- value}:}{
Set the feature names.
}
\item{\code{variant_id(object)}:}{
Get the variant names.
}
\item{\code{variant_id(object) <- value}:}{
Set the variant names.
}
}
}

\examples{
qtle <- mockQTLE()
feature_id(qtle) <- gsub("gene", "Gene", feature_id(qtle))
feature_id(qtle)
variant_id(qtle) <- paste0(variant_id(qtle), "000")
variant_id(qtle)

}
\seealso{
\linkS4class{QTLExperiment}, for the underlying class definition.
}
\author{
Christina B Azodi, Amelia Dunstone
}
