% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_afs.R
\name{fit_afs}
\alias{fit_afs}
\title{Given target data, fit the AFS function}
\usage{
fit_afs(Observed_bin_props, p_rv = NULL)
}
\arguments{
\item{Observed_bin_props}{data frame with 3 columns, Lower, Upper (of MAC bins)  and proportion of variants in that MAC bin}

\item{p_rv}{proportion of rare variants - default is the sum of the rare MAC bin proportions}
}
\value{
list of parameters - alpha, beta, and b as well as fitted proportions
}
\description{
This function takes AFS target data and estimates parameters for the AFS function
A dataframe specifying the rare MAC bins and the observed proportion of variants is used to fit the data
The proportion of rare variants (p_rv) is by default the sum of the rare allele count bins. The proportion be manually specified if desired
}
\examples{
data("afs_afr")
fit_afs(Observed_bin_props = afs_afr)

}
